/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.netty.ssl;

import java.util.HashSet;
import java.util.Set;
import org.apache.camel.Message;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.ssl.SslHandler;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.common.composer.SecurityBindingData;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.extractor.SSLSessionCredentialExtractor;

public class NettyBindingData
extends CamelBindingData
implements SecurityBindingData {
    public NettyBindingData(Message message) {
        super(message);
    }

    public Set<Credential> extractCredentials() {
        SslHandler sslHandler;
        HashSet<Credential> credentials = new HashSet<Credential>();
        ChannelHandlerContext handlerContext = (ChannelHandlerContext)this.getMessage().getHeader("CamelNettyChannelHandlerContext", ChannelHandlerContext.class);
        if (handlerContext != null && (sslHandler = (SslHandler)handlerContext.getPipeline().get(SslHandler.class)) != null) {
            credentials.addAll(new SSLSessionCredentialExtractor().extract(sslHandler.getEngine().getSession()));
        }
        return credentials;
    }
}

