/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.StandardErrorHandler;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.EventSource;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.ParseOptions;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorToReceiver;
import net.sf.saxon.evpull.PullEventSource;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.pull.StaxBridge;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Sender {
    private static Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static Class staxSourceClass;
    PipelineConfiguration pipe;

    public Sender(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public void send(Source source, Receiver receiver, ParseOptions options) throws XPathException {
        Controller controller;
        options = options == null ? new ParseOptions() : new ParseOptions(options);
        boolean isFinal = options.isContinueAfterValidationErrors();
        if (source instanceof AugmentedSource) {
            options.merge(((AugmentedSource)source).getParseOptions());
            source = ((AugmentedSource)source).getContainedSource();
        }
        Configuration config = this.pipe.getConfiguration();
        options.applyDefaults(config);
        receiver.setPipelineConfiguration(this.pipe);
        receiver.setSystemId(source.getSystemId());
        Receiver next = receiver;
        int schemaValidation = options.getSchemaValidationMode();
        if (isFinal) {
            schemaValidation |= 0x10000;
        }
        SchemaType topLevelType = options.getTopLevelType();
        List filters = options.getFilters();
        if (filters != null) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                ProxyReceiver filter = (ProxyReceiver)filters.get(i);
                filter.setPipelineConfiguration(this.pipe);
                filter.setSystemId(source.getSystemId());
                filter.setUnderlyingReceiver(next);
                next = filter;
            }
        }
        if (options.getStripSpace() == 2) {
            AllElementStripper s = new AllElementStripper();
            s.setStripAll();
            s.setPipelineConfiguration(this.pipe);
            s.setUnderlyingReceiver(receiver);
            next = s;
        } else if (options.getStripSpace() == 4 && (controller = this.pipe.getController()) != null) {
            next = controller.makeStripper(next);
        }
        if (source instanceof NodeInfo) {
            int kind;
            NodeInfo ns = (NodeInfo)source;
            String baseURI = ns.getBaseURI();
            int val = schemaValidation & 0xFF;
            if (val != 3) {
                StructuredQName topLevelName = options.getTopLevelElement();
                int topLevelNameCode = -1;
                if (topLevelName != null) {
                    topLevelNameCode = config.getNamePool().allocate(topLevelName.getPrefix(), topLevelName.getNamespaceURI(), topLevelName.getLocalName());
                }
                next = config.getDocumentValidator(next, baseURI, val, options.getStripSpace(), topLevelType, topLevelNameCode);
            }
            if ((kind = ns.getNodeKind()) != 9 && kind != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            next.setSystemId(baseURI);
            this.sendDocumentInfo(ns, next);
            return;
        }
        if (source instanceof PullSource) {
            this.sendPullSource((PullSource)source, next, options);
            return;
        }
        if (source instanceof PullEventSource) {
            this.sendPullEventSource((PullEventSource)source, next, options);
            return;
        }
        if (source instanceof EventSource) {
            ((EventSource)source).send(next);
            return;
        }
        if (source instanceof SAXSource) {
            this.sendSAXSource((SAXSource)source, next, options);
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            boolean dtdValidation = options.getDTDValidationMode() == 1;
            Source ps = Configuration.getPlatform().getParserSource(this.pipe, ss, schemaValidation, dtdValidation, options.getStripSpace());
            if (ps == ss) {
                String url = source.getSystemId();
                InputSource is = new InputSource(url);
                is.setCharacterStream(ss.getReader());
                is.setByteStream(ss.getInputStream());
                boolean reuseParser = false;
                XMLReader parser = options.getXMLReader();
                if (parser == null) {
                    parser = config.getSourceParser();
                    if (options.getEntityResolver() != null) {
                        parser.setEntityResolver(options.getEntityResolver());
                    }
                    reuseParser = true;
                }
                SAXSource sax = new SAXSource(parser, is);
                sax.setSystemId(source.getSystemId());
                this.sendSAXSource(sax, next, options);
                if (reuseParser) {
                    config.reuseSourceParser(parser);
                }
            } else {
                this.send(ps, next, options);
            }
            return;
        }
        if (staxSourceClass != null && staxSourceClass.isAssignableFrom(source.getClass())) {
            XMLStreamReader reader = null;
            try {
                Method getReaderMethod = staxSourceClass.getMethod("getXMLStreamReader", EMPTY_CLASS_ARRAY);
                reader = (XMLStreamReader)getReaderMethod.invoke((Object)source, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (reader == null) {
                throw new XPathException("Saxon can only handle a StAXSource that wraps an XMLStreamReader");
            }
            StaxBridge bridge = new StaxBridge();
            bridge.setXMLStreamReader(reader);
            this.sendPullSource(new PullSource(bridge), next, options);
            return;
        }
        next = this.makeValidator(next, source.getSystemId(), options);
        Source newSource = config.getSourceResolver().resolveSource(source, config);
        if (newSource instanceof StreamSource || newSource instanceof SAXSource || newSource instanceof NodeInfo || newSource instanceof PullSource || newSource instanceof AugmentedSource || newSource instanceof EventSource) {
            this.send(newSource, next, options);
        }
        List<ExternalObjectModel> externalObjectModels = config.getExternalObjectModels();
        for (int m = 0; m < externalObjectModels.size(); ++m) {
            ExternalObjectModel model = externalObjectModels.get(m);
            boolean done = model.sendSource(source, next, this.pipe);
            if (!done) continue;
            return;
        }
        throw new XPathException("A source of type " + source.getClass().getName() + " is not supported in this environment");
    }

    private void sendDocumentInfo(NodeInfo top, Receiver receiver) throws XPathException {
        NamePool targetNamePool = this.pipe.getConfiguration().getNamePool();
        if (top.getNamePool() != targetNamePool) {
            NamePoolConverter converter = new NamePoolConverter(top.getNamePool(), targetNamePool);
            converter.setUnderlyingReceiver(receiver);
            converter.setPipelineConfiguration(receiver.getPipelineConfiguration());
            receiver = converter;
        }
        DocumentSender sender = new DocumentSender(top);
        LocationCopier copier = new LocationCopier(top instanceof DocumentInfo);
        this.pipe.setCopyInformee(copier);
        this.pipe.setLocationProvider(copier);
        sender.send(receiver);
    }

    private void sendSAXSource(SAXSource source, Receiver receiver, ParseOptions options) throws XPathException {
        ReceivingContentHandler ce;
        boolean dtdRecover;
        StandardErrorHandler standardErrorHandler;
        ErrorListener listener;
        Configuration config;
        boolean reuseParser;
        XMLReader parser;
        block43: {
            parser = source.getXMLReader();
            reuseParser = false;
            config = this.pipe.getConfiguration();
            listener = options.getErrorListener();
            if (listener == null) {
                listener = this.pipe.getErrorListener();
            }
            standardErrorHandler = new StandardErrorHandler(listener);
            if (parser == null) {
                parser = options.getXMLReader();
            }
            if (parser == null) {
                SAXSource ss = new SAXSource();
                ss.setInputSource(source.getInputSource());
                ss.setSystemId(source.getSystemId());
                parser = config.getSourceParser();
                parser.setErrorHandler(standardErrorHandler);
                if (options.getEntityResolver() != null) {
                    parser.setEntityResolver(options.getEntityResolver());
                }
                ss.setXMLReader(parser);
                source = ss;
                reuseParser = true;
            } else {
                Sender.configureParser(parser);
                if (parser.getErrorHandler() == null) {
                    parser.setErrorHandler(standardErrorHandler);
                }
            }
            if (!this.pipe.isExpandAttributeDefaults()) {
                try {
                    parser.setFeature("http://xml.org/sax/features/use-attributes2", true);
                }
                catch (SAXNotRecognizedException err) {
                }
                catch (SAXNotSupportedException err) {
                    // empty catch block
                }
            }
            boolean dtdValidation = options.getDTDValidationMode() == 1 || options.getDTDValidationMode() == 2;
            dtdRecover = options.getDTDValidationMode() == 2;
            try {
                parser.setFeature("http://xml.org/sax/features/validation", dtdValidation);
            }
            catch (SAXNotRecognizedException err) {
                if (dtdValidation) {
                    throw new XPathException("XML Parser does not recognize request for DTD validation", err);
                }
            }
            catch (SAXNotSupportedException err) {
                if (!dtdValidation) break block43;
                throw new XPathException("XML Parser does not support DTD validation", err);
            }
        }
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            boolean tryAgain = false;
            try {
                parser.setFeature("http://apache.org/xml/features/xinclude-aware", true);
            }
            catch (SAXNotRecognizedException err) {
                tryAgain = true;
            }
            catch (SAXNotSupportedException err) {
                tryAgain = true;
            }
            if (tryAgain) {
                try {
                    parser.setFeature("http://apache.org/xml/features/xinclude", true);
                }
                catch (SAXNotRecognizedException err) {
                    throw new XPathException("Selected XML parser " + parser.getClass().getName() + " does not recognize request for XInclude processing", err);
                }
                catch (SAXNotSupportedException err) {
                    throw new XPathException("Selected XML parser " + parser.getClass().getName() + " does not support XInclude processing", err);
                }
            }
        }
        receiver = this.makeValidator(receiver, source.getSystemId(), options);
        ContentHandler ch = parser.getContentHandler();
        if (ch instanceof ReceivingContentHandler && config.isCompatible(((ReceivingContentHandler)ch).getConfiguration())) {
            ce = (ReceivingContentHandler)ch;
            ce.reset();
        } else {
            ce = new ReceivingContentHandler();
            parser.setContentHandler(ce);
            parser.setDTDHandler(ce);
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", ce);
            }
            catch (SAXNotSupportedException err) {
            }
            catch (SAXNotRecognizedException err) {
                // empty catch block
            }
        }
        ce.setReceiver(receiver);
        ce.setPipelineConfiguration(this.pipe);
        try {
            parser.parse(source.getInputSource());
        }
        catch (SAXException err) {
            Exception nested = err.getException();
            if (nested instanceof XPathException) {
                throw (XPathException)nested;
            }
            if (nested instanceof RuntimeException) {
                throw (RuntimeException)nested;
            }
            if (standardErrorHandler != null && standardErrorHandler.getFatalErrorCount() == 0) {
                XPathException de = new XPathException("Error reported by XML parser processing " + source.getSystemId() + ": " + err.getMessage(), err);
                try {
                    listener.fatalError(de);
                    de.setHasBeenReported(true);
                }
                catch (TransformerException e) {
                    // empty catch block
                }
                throw de;
            }
            XPathException de = new XPathException(err);
            de.setHasBeenReported(true);
            throw de;
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
        if (standardErrorHandler != null) {
            int errs = standardErrorHandler.getFatalErrorCount();
            if (errs > 0) {
                throw new XPathException("The XML parser reported " + errs + (errs == 1 ? " error" : " errors"));
            }
            errs = standardErrorHandler.getErrorCount();
            if (errs > 0) {
                XPathException xe = new XPathException("The XML parser reported " + errs + " validation error" + (errs == 1 ? "" : "s"));
                if (dtdRecover) {
                    try {
                        listener.warning(xe);
                    }
                    catch (TransformerException e) {}
                } else {
                    throw xe;
                }
            }
        }
        if (reuseParser) {
            config.reuseSourceParser(parser);
        }
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Receiver makeValidator(Receiver receiver, String systemId, ParseOptions options) {
        Configuration config = this.pipe.getConfiguration();
        int schemaValidation = options.getSchemaValidationMode();
        if ((schemaValidation & 0xFF) != 3) {
            int stripSpace = options.getStripSpace();
            SchemaType topLevelType = options.getTopLevelType();
            StructuredQName topLevelElement = options.getTopLevelElement();
            int topLevelElementCode = -1;
            if (topLevelElement != null) {
                topLevelElementCode = config.getNamePool().allocate(topLevelElement.getPrefix(), topLevelElement.getNamespaceURI(), topLevelElement.getLocalName());
            }
            receiver = config.getDocumentValidator(receiver, systemId, schemaValidation, stripSpace, topLevelType, topLevelElementCode);
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPullSource(PullSource source, Receiver receiver, ParseOptions options) throws XPathException {
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = this.makeValidator(receiver, source.getSystemId(), options);
        PullProvider provider = source.getPullProvider();
        if (provider instanceof LocationProvider) {
            this.pipe.setLocationProvider((LocationProvider)((Object)provider));
        }
        provider.setPipelineConfiguration(this.pipe);
        receiver.setPipelineConfiguration(this.pipe);
        PullPushCopier copier = new PullPushCopier(provider, receiver);
        try {
            copier.copy();
        }
        finally {
            if (options.isPleaseCloseAfterUse()) {
                provider.close();
            }
        }
    }

    private void sendPullEventSource(PullEventSource source, Receiver receiver, ParseOptions options) throws XPathException {
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = this.makeValidator(receiver, source.getSystemId(), options);
        receiver.open();
        EventIterator provider = source.getEventIterator();
        if (provider instanceof LocationProvider) {
            this.pipe.setLocationProvider((LocationProvider)((Object)provider));
        }
        receiver.setPipelineConfiguration(this.pipe);
        SequenceReceiver out = receiver instanceof SequenceReceiver ? (SequenceReceiver)receiver : new TreeReceiver(receiver);
        EventIteratorToReceiver.copy(provider, out);
        receiver.close();
    }

    public static void configureParser(XMLReader parser) throws XPathException {
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespaces' feature", err);
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespaces' feature to true", err);
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespace-prefixes' feature", err);
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespace-prefixes' feature to false", err);
        }
    }

    static {
        try {
            staxSourceClass = Class.forName("javax.xml.transform.stax.StAXSource");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

