/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.APILogger;
import org.switchyard.APIMessages;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.SwitchYardException;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.transform.TransformationFailureException;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public final class TransformSequence
implements Serializable {
    static final long serialVersionUID = -1L;
    private static final Logger LOGGER = Logger.getLogger(TransformSequence.class);
    private List<QName> _sequence = new ArrayList<QName>();

    private TransformSequence() {
    }

    public void associateWith(Message message) {
        message.getContext().setProperty(TransformSequence.class.getName(), this).addLabels(BehaviorLabel.TRANSIENT.label());
    }

    public static TransformSequence from(QName typeName) {
        TransformSequence newSequence = new TransformSequence();
        newSequence.add(typeName);
        return newSequence;
    }

    public TransformSequence to(QName typeName) {
        this.add(typeName);
        return this;
    }

    public void apply(Message message, TransformerRegistry registry) throws TransformationFailureException {
        QName to;
        QName from;
        Transformer<?, ?> transformer;
        while (this._sequence.size() > 1 && (transformer = registry.getTransformer(from = this._sequence.get(0), to = this._sequence.get(1))) != null) {
            Object result;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Transforming Message (" + System.identityHashCode(message) + ") from '" + transformer.getFrom() + "' to '" + transformer.getTo() + "' using transformer type '" + transformer.getClass().getName() + "'."));
            }
            try {
                if (Message.class.isAssignableFrom(transformer.getFromType())) {
                    result = transformer.transform(message);
                } else {
                    result = transformer.transform(message.getContent(transformer.getFromType()));
                    message.setContent(result);
                }
            }
            catch (SwitchYardException e) {
                String msg = APIMessages.MESSAGES.transformerFailed(transformer.getClass().getName(), transformer.getFromType().getName(), transformer.getFrom().toString(), transformer.getToType().getName(), transformer.getTo().toString(), e);
                throw new TransformationFailureException(transformer, e.getCause() != null ? e.getCause() : e, msg);
            }
            this._sequence.remove(0);
            if (result != null) continue;
            APILogger.ROOT_LOGGER.nullTransformResult(transformer.getClass().getName(), from, to);
        }
    }

    public static QName getCurrentMessageType(Exchange exchange) {
        TransformSequence transformSequence = TransformSequence.get(exchange);
        if (transformSequence != null && !transformSequence._sequence.isEmpty()) {
            return transformSequence._sequence.get(0);
        }
        return null;
    }

    public static QName getTargetMessageType(Exchange exchange) {
        TransformSequence transformSequence = TransformSequence.get(exchange);
        if (transformSequence != null && !transformSequence._sequence.isEmpty()) {
            return transformSequence._sequence.get(transformSequence._sequence.size() - 1);
        }
        return null;
    }

    public static boolean assertTransformsApplied(Exchange exchange) {
        QName fromName = TransformSequence.getCurrentMessageType(exchange);
        QName toName = TransformSequence.getTargetMessageType(exchange);
        return fromName == null || toName == null || fromName.equals(toName);
    }

    public static void applySequence(Exchange exchange, TransformerRegistry registry) throws TransformationFailureException {
        Message message = exchange.getMessage();
        TransformSequence transformSequence = TransformSequence.get(exchange);
        if (transformSequence == null) {
            return;
        }
        transformSequence.apply(message, registry);
    }

    private void add(QName typeName) {
        if (typeName == null) {
            throw APIMessages.MESSAGES.nullTypeNamePassed();
        }
        this._sequence.add(typeName);
    }

    private static TransformSequence get(Exchange exchange) {
        Property sequenceProperty = exchange.getContext().getProperty(TransformSequence.class.getName());
        if (sequenceProperty != null) {
            return (TransformSequence)sequenceProperty.getValue();
        }
        return null;
    }
}

