/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph;

import org.switchyard.common.type.reflect.Construction;
import org.switchyard.serial.graph.DefaultFactory;
import org.switchyard.serial.graph.Strategy;
import org.switchyard.serial.graph.ThrowableFactory;
import org.switchyard.serial.graph.node.Node;

public abstract class Factory<T> {
    public abstract boolean supports(Class<?> var1);

    public abstract T create(Class<T> var1, Node var2);

    public static final <T> Factory<T> getFactory(Class<T> type) {
        Class<? extends Factory> factoryClass;
        Strategy strategy = type.getAnnotation(Strategy.class);
        if (strategy != null && !UndefinedFactory.class.equals(factoryClass = strategy.factory())) {
            return (Factory)Construction.construct(factoryClass);
        }
        if (Throwable.class.isAssignableFrom(type)) {
            return new ThrowableFactory();
        }
        return new DefaultFactory();
    }

    static final class UndefinedFactory<T>
    extends Factory<T> {
        UndefinedFactory() {
        }

        @Override
        public boolean supports(Class<?> type) {
            return false;
        }

        @Override
        public T create(Class<T> type, Node node) {
            return null;
        }
    }
}

