/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime.explang.konst;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.explang.ConfigurationException;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.explang.ExpressionLanguageRuntime;
import org.apache.ode.bpel.explang.TypeCastException;
import org.apache.ode.bpel.o.OConstantExpression;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.utils.xsd.Duration;
import org.w3c.dom.Node;

public class KonstExpressionLanguageRuntimeImpl
implements ExpressionLanguageRuntime {
    public void initialize(Map properties) throws ConfigurationException {
    }

    public String evaluateAsString(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        OConstantExpression konst = (OConstantExpression)cexp;
        if (konst.getVal() instanceof String) {
            return (String)konst.getVal();
        }
        throw new TypeCastException(0, konst.getVal().toString());
    }

    public boolean evaluateAsBoolean(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        OConstantExpression konst = (OConstantExpression)cexp;
        if (konst.getVal() instanceof Boolean) {
            return (Boolean)konst.getVal();
        }
        throw new TypeCastException(4, konst.getVal().toString());
    }

    public Number evaluateAsNumber(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        OConstantExpression konst = (OConstantExpression)cexp;
        if (konst.getVal() instanceof Number) {
            return (Number)konst.getVal();
        }
        throw new TypeCastException(6, konst.getVal().toString());
    }

    public List evaluate(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        OConstantExpression konst = (OConstantExpression)cexp;
        if (konst.getVal() instanceof List) {
            return (List)konst.getVal();
        }
        throw new TypeCastException(3, konst.getVal().toString());
    }

    public Node evaluateNode(OExpression cexp, EvaluationContext context) throws FaultException, EvaluationException {
        OConstantExpression konst = (OConstantExpression)cexp;
        if (konst.getVal() instanceof Node) {
            return (Node)konst.getVal();
        }
        throw new TypeCastException(5, konst.getVal().toString());
    }

    public Calendar evaluateAsDate(OExpression cexp, EvaluationContext context) throws FaultException, EvaluationException {
        OConstantExpression konst = (OConstantExpression)cexp;
        if (konst.getVal() instanceof Calendar) {
            return (Calendar)konst.getVal();
        }
        throw new TypeCastException(1, konst.getVal().toString());
    }

    public Duration evaluateAsDuration(OExpression cexp, EvaluationContext context) throws FaultException, EvaluationException {
        OConstantExpression konst = (OConstantExpression)cexp;
        if (konst.getVal() instanceof Duration) {
            return (Duration)konst.getVal();
        }
        throw new TypeCastException(2, konst.getVal().toString());
    }
}

