/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.internal;

import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.component.bean.ReferenceInvocation;
import org.switchyard.component.bean.internal.InvocationResponseHandler;

public class ExchangeInvocation
implements ReferenceInvocation {
    private Exchange _exchange;
    private Message _inMessage;
    private InvocationResponseHandler _replyHandler;

    public ExchangeInvocation(Exchange exchange, InvocationResponseHandler replyHandler) {
        this._exchange = exchange;
        this._inMessage = this._exchange.createMessage();
        this._replyHandler = replyHandler;
    }

    @Override
    public Context getContext() {
        return this._exchange.getContext();
    }

    @Override
    public Message getMessage() {
        return this.isNew() ? this._inMessage : this._exchange.getMessage();
    }

    @Override
    public ReferenceInvocation invoke() throws Exception {
        if (!this.isNew()) {
            throw new IllegalStateException("Repeated calls to invoke() on ExchangeInvocation are not permitted");
        }
        this._exchange.send(this._inMessage);
        if (this._replyHandler.isFault()) {
            Object error = this._replyHandler.getExchange().getMessage().getContent();
            if (!Throwable.class.isAssignableFrom(error.getClass())) {
                throw this.createException(this._replyHandler.getExchange());
            }
            if (error instanceof HandlerException) {
                HandlerException haEx = (HandlerException)error;
                Object object = error = haEx.isWrapper() ? haEx.getCause() : haEx;
            }
            if (error instanceof Exception) {
                throw (Exception)error;
            }
            throw new Exception((Throwable)error);
        }
        return this;
    }

    @Override
    public ReferenceInvocation invoke(Object content) throws Exception {
        this._inMessage.setContent(content);
        return this.invoke();
    }

    @Override
    public ReferenceInvocation setProperty(String name, String value) {
        this._exchange.getContext(this._inMessage).setProperty(name, (Object)value);
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return this._exchange.getContext().getPropertyValue(name);
    }

    boolean isNew() {
        return this._exchange.getPhase() == null;
    }

    Exception createException(Exchange exchange) {
        String exMsg;
        block2: {
            exMsg = null;
            try {
                exMsg = (String)exchange.getMessage().getContent(String.class);
            }
            catch (Exception ex) {
                Object content = exchange.getMessage().getContent();
                if (content == null) break block2;
                exMsg = content.toString();
            }
        }
        return new Exception(exMsg);
    }
}

