/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.camel;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.RejectableScheduledThreadPoolExecutor;
import org.apache.camel.util.concurrent.RejectableThreadPoolExecutor;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;
import org.jboss.as.naming.context.NamespaceContextSelector;

public class JBossThreadPoolFactory
implements ThreadPoolFactory {
    private NamespaceContextSelector _contextSelector;

    public JBossThreadPoolFactory(NamespaceContextSelector contextSelector) {
        this._contextSelector = contextSelector;
    }

    public ScheduledExecutorService newScheduledThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
        RejectedExecutionHandler rejectedExecutionHandler = profile.getRejectedExecutionHandler();
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        }
        RejectableScheduledThreadPoolExecutor answer = new RejectableScheduledThreadPoolExecutor(profile.getPoolSize(), threadFactory, rejectedExecutionHandler){

            protected void beforeExecute(Thread t, Runnable r) {
                super.beforeExecute(t, r);
                JBossThreadPoolFactory.this.before();
            }

            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                JBossThreadPoolFactory.this.after();
            }
        };
        if (profile.getMaxPoolSize() > 0) {
            return new SizedScheduledExecutorService((ScheduledThreadPoolExecutor)answer, (long)profile.getMaxQueueSize().intValue());
        }
        return answer;
    }

    public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue()){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                super.beforeExecute(t, r);
                JBossThreadPoolFactory.this.before();
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                JBossThreadPoolFactory.this.after();
            }
        };
    }

    public ExecutorService newThreadPool(ThreadPoolProfile profile, ThreadFactory factory) {
        return this.newThreadPool(profile.getPoolSize(), profile.getMaxPoolSize(), profile.getKeepAliveTime(), profile.getTimeUnit(), profile.getMaxQueueSize(), profile.getRejectedExecutionHandler(), factory);
    }

    public ExecutorService newThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) throws IllegalArgumentException {
        AbstractQueue workQueue;
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("CorePoolSize must be >= 0, was " + corePoolSize);
        }
        if (maxPoolSize < corePoolSize) {
            throw new IllegalArgumentException("MaxPoolSize must be >= corePoolSize, was " + maxPoolSize + " >= " + corePoolSize);
        }
        if (corePoolSize == 0 && maxQueueSize <= 0) {
            workQueue = new SynchronousQueue();
            corePoolSize = 1;
            maxPoolSize = 1;
        } else {
            workQueue = maxQueueSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(maxQueueSize);
        }
        RejectableThreadPoolExecutor answer = new RejectableThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, (BlockingQueue)((Object)workQueue)){

            protected void beforeExecute(Thread t, Runnable r) {
                super.beforeExecute(t, r);
                JBossThreadPoolFactory.this.before();
            }

            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                JBossThreadPoolFactory.this.after();
            }
        };
        answer.setThreadFactory(threadFactory);
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        }
        answer.setRejectedExecutionHandler(rejectedExecutionHandler);
        return answer;
    }

    private void before() {
        NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this._contextSelector);
    }

    private void after() {
        NamespaceContextSelector.popCurrentSelector();
    }
}

