/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.type.reflect;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.switchyard.common.type.reflect.Access;

public final class BeanAccess<T>
implements Access<T> {
    private PropertyDescriptor _propDesc;

    public BeanAccess(PropertyDescriptor propDesc) {
        this._propDesc = propDesc;
    }

    @Override
    public String getName() {
        return this._propDesc.getName();
    }

    @Override
    public Class<T> getType() {
        return this._propDesc.getPropertyType();
    }

    @Override
    public boolean isReadable() {
        return this._propDesc.getReadMethod() != null;
    }

    @Override
    public boolean isWriteable() {
        return this._propDesc.getWriteMethod() != null;
    }

    @Override
    public T read(Object target) {
        Method readMethod = this._propDesc.getReadMethod();
        if (readMethod != null) {
            try {
                return (T)readMethod.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite);
            }
        }
        return null;
    }

    @Override
    public void write(Object target, T value) {
        Method writeMethod = this._propDesc.getWriteMethod();
        if (writeMethod != null) {
            try {
                writeMethod.invoke(target, value);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite);
            }
        }
    }

    public String toString() {
        Class<T> clazz = this.getType();
        String type = clazz != null ? clazz.getSimpleName() : null;
        return String.format("MethodAccess(name=%s, type=%s, readable=%b, writeable=%b)", this.getName(), type, this.isReadable(), this.isWriteable());
    }
}

