/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.compiler;

import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.compiler.XslCompileUriResolver;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10Expression;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OXslSheet;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath20ExpressionBPEL20 _out;
    private NSContext _nsContext;
    private String _bpelNS;
    private static final String JAVA_PREFIX = "java:";
    private static final Log __log = LogFactory.getLog(JaxpFunctionResolver.class);

    public JaxpFunctionResolver(CompilerContext cctx, OXPath20ExpressionBPEL20 out, NSContext nsContext, String bpelNS) {
        this._cctx = cctx;
        this._bpelNS = bpelNS;
        this._nsContext = nsContext;
        this._bpelNS = bpelNS;
        this._out = out;
    }

    @Override
    public XPathFunction resolveFunction(QName functionName, int arity) {
        if (functionName.getNamespaceURI() == null) {
            throw new WrappedResolverException("Undeclared namespace for " + functionName);
        }
        if (functionName.getNamespaceURI().equals(this._bpelNS)) {
            String localName = functionName.getLocalPart();
            if ("getVariableProperty".equals(localName)) {
                return new GetVariableProperty();
            }
            if ("doXslTransform".equals(localName)) {
                return new DoXslTransform();
            }
            throw new WrappedResolverException(__msgs.errUnknownBpelFunction(localName));
        }
        if (functionName.getNamespaceURI().equals(Namespaces.ODE_EXTENSION_NS)) {
            String localName = functionName.getLocalPart();
            if ("split-to-elements".equals(localName) || "splitToElements".equals(localName)) {
                return new SplitToElements();
            }
            if ("combine-url".equals(localName) || "combineUrl".equals(localName)) {
                return new CombineUrl();
            }
            if ("compose-url".equals(localName) || "expand-template".equals(localName) || "composeUrl".equals(localName) || "expandTemplate".equals(localName)) {
                return new ComposeUrl();
            }
            if ("dom-to-string".equals(localName) || "domToString".equals(localName)) {
                return new DomToString();
            }
            if ("insert-after".equals(localName)) {
                return new InsertAfter();
            }
            if ("insert-as-first-into".equals(localName)) {
                return new InsertAsFirstInto();
            }
            if ("insert-as-last-into".equals(localName)) {
                return new InsertAsLastInto();
            }
            if ("insert-before".equals(localName)) {
                return new InsertBefore();
            }
            if ("delete".equals(localName)) {
                return new Delete();
            }
            if ("rename".equals(localName)) {
                return new Rename();
            }
            if ("process-property".equals(localName)) {
                return new ProcessProperty();
            }
        } else if (functionName.getNamespaceURI().equals(Namespaces.DEPRECATED_XDT_NS)) {
            String localName = functionName.getLocalPart();
            if ("dayTimeDuration".equals(localName)) {
                return new DayTimeDuration();
            }
            if ("yearMonthDuration".equals(localName)) {
                return new YearMonthDuration();
            }
        } else if (functionName.getNamespaceURI().startsWith(JAVA_PREFIX)) {
            return new JavaFunction(functionName);
        }
        return null;
    }

    public class JavaFunction
    implements XPathFunction {
        private Method _method = null;
        private QName _functionName = null;

        public JavaFunction(QName functionName) {
            this._functionName = functionName;
            String javaClassName = functionName.getNamespaceURI().substring(JaxpFunctionResolver.JAVA_PREFIX.length());
            try {
                Class<?> cls = Class.forName(javaClassName);
                for (Method m : cls.getMethods()) {
                    if (!m.getName().equals(functionName.getLocalPart())) continue;
                    this._method = m;
                    break;
                }
                if (this._method != null && (this._method.getModifiers() & 8) == 0) {
                    __log.error((Object)("Java method implementing XPath function '" + functionName + "' is not static"));
                    this._method = null;
                }
            }
            catch (Exception e) {
                __log.error((Object)("Unable to locate XPath function '" + functionName + "'"), (Throwable)e);
            }
        }

        public Object evaluate(List params) throws XPathFunctionException {
            if (this._method == null) {
                throw new CompilationException(__msgs.errUnknownBpelFunction(this._functionName.toString()));
            }
            if (params.size() != this._method.getParameterTypes().length ? this._method.getParameterTypes().length <= 0 || this._method.getParameterTypes().length != params.size() + 1 || this._method.getParameterTypes()[0] != QName.class : this._method.getParameterTypes().length > 0 && this._method.getParameterTypes()[0] == QName.class) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments(this._functionName.toString()));
            }
            return "";
        }
    }

    public static class YearMonthDuration
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 1) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("yearMonthDuration"));
            }
            return "";
        }
    }

    public static class DayTimeDuration
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 1) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("dayTimeDuration"));
            }
            return "";
        }
    }

    public static class ProcessProperty
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 1) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("process-property"));
            }
            return "";
        }
    }

    public static class Rename
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() < 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("rename"));
            }
            return "";
        }
    }

    public static class Delete
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() < 1 || args.size() > 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("delete"));
            }
            return "";
        }
    }

    public static class InsertAsLastInto
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-as-last-into"));
            }
            return "";
        }
    }

    public static class InsertAsFirstInto
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-as-first-into"));
            }
            return "";
        }
    }

    public static class InsertBefore
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() < 2 || args.size() > 3) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-before"));
            }
            return "";
        }
    }

    public static class InsertAfter
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() < 2 || args.size() > 3) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-after"));
            }
            return "";
        }
    }

    public static class InsertInto
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 3) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-after"));
            }
            return "";
        }
    }

    public static class ComposeUrl
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2 && (args.size() <= 2 || args.size() % 2 != 1)) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("compose-url"));
            }
            return "";
        }
    }

    public static class DomToString
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 1) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("dom-to-string"));
            }
            return "";
        }
    }

    public static class CombineUrl
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("combine-url"));
            }
            return "";
        }
    }

    public static class SplitToElements
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() < 3 || params.size() > 4) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("split-to-elements"));
            }
            return "";
        }
    }

    public class DoXslTransform
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() < 2 || params.size() % 2 != 0) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("doXslTransform"));
            }
            String xslUri = (String)params.get(0);
            OXslSheet xslSheet = JaxpFunctionResolver.this._cctx.compileXslt(xslUri);
            try {
                XslTransformHandler.getInstance().parseXSLSheet(JaxpFunctionResolver.this._cctx.getOProcess().getQName(), xslSheet.uri, xslSheet.sheetBody, (URIResolver)new XslCompileUriResolver(JaxpFunctionResolver.this._cctx, (OXPath10Expression)JaxpFunctionResolver.this._out));
            }
            catch (Exception e) {
                throw new CompilationException(__msgs.errXslCompilation(xslUri, e.toString()));
            }
            JaxpFunctionResolver.this._out.setXslSheet(xslSheet.uri, xslSheet);
            return "";
        }
    }

    public class GetVariableProperty
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("getVariableProperty"));
            }
            String varName = (String)params.get(0);
            OScope.Variable v = JaxpFunctionResolver.this._cctx.resolveVariable(varName);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(varName, v);
            String propName = (String)params.get(1);
            QName qname = JaxpFunctionResolver.this._nsContext.derefQName(propName);
            if (qname == null) {
                throw new CompilationException(__msgs.errInvalidQName(propName));
            }
            OProcess.OProperty property = JaxpFunctionResolver.this._cctx.resolveProperty(qname);
            JaxpFunctionResolver.this._cctx.resolvePropertyAlias(v, qname);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.properties.put(propName, property);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(varName, v);
            return "";
        }
    }
}

