/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceCodeIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;

public class InScopePrefixes
extends SystemFunction {
    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        NodeInfo element = (NodeInfo)this.argument[0].evaluateItem(context);
        final IntIterator iter = NamespaceCodeIterator.iterateNamespaces(element);
        final NamePool pool = context.getNamePool();
        return new SequenceIterator(){
            private Item current = null;
            private int position = 0;

            public Item current() {
                return this.current;
            }

            public SequenceIterator getAnother() throws XPathException {
                return InScopePrefixes.this.iterate(context);
            }

            public int getProperties() {
                return 0;
            }

            public Item next() throws XPathException {
                if (this.position == 0) {
                    this.current = new StringValue("xml");
                    ++this.position;
                    return this.current;
                }
                if (iter.hasNext()) {
                    String prefix = pool.getPrefixFromNamespaceCode(iter.next());
                    this.current = prefix.length() == 0 ? StringValue.EMPTY_STRING : StringValue.makeRestrictedString(prefix, BuiltInAtomicType.NCNAME, null).asAtomic();
                    ++this.position;
                    return this.current;
                }
                this.current = null;
                this.position = -1;
                return null;
            }

            public int position() {
                return this.position;
            }

            public void close() {
            }
        };
    }
}

