/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.jms.message.creationstrategies;

import org.milyn.routing.jms.message.creationstrategies.MapMessageCreationStrategy;
import org.milyn.routing.jms.message.creationstrategies.MessageCreationStrategy;
import org.milyn.routing.jms.message.creationstrategies.ObjectMessageCreationStrategy;
import org.milyn.routing.jms.message.creationstrategies.TextMessageCreationStrategy;

public final class StrategyFactory {
    private static StrategyFactory instance = new StrategyFactory();
    public static final String TEXT_MESSAGE = "TextMessage";
    public static final String OBJECT_MESSAGE = "ObjectMessage";
    public static final String MAP_MESSAGE = "MapMessage";

    private StrategyFactory() {
    }

    public static StrategyFactory getInstance() {
        return instance;
    }

    public MessageCreationStrategy createStrategy(String messageType) {
        if (messageType.equals(TEXT_MESSAGE)) {
            return new TextMessageCreationStrategy();
        }
        if (messageType.equals(OBJECT_MESSAGE)) {
            return new ObjectMessageCreationStrategy();
        }
        if (messageType.equals(MAP_MESSAGE)) {
            return new MapMessageCreationStrategy();
        }
        throw new IllegalArgumentException("No strategy for messageType [" + messageType + "] was found.");
    }
}

