/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.internal.exchange;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeSecurity;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.component.bean.BeanMessages;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceOperation;

@ApplicationScoped
@Alternative
public class ExchangeProxy
implements Exchange {
    private static final ThreadLocal<Exchange> EXCHANGE = new ThreadLocal();

    private static Exchange getExchange() {
        Exchange exchange = EXCHANGE.get();
        if (exchange == null) {
            throw BeanMessages.MESSAGES.illegalExchangeAccessOutsideHandlerChain();
        }
        return exchange;
    }

    public static Exchange setExchange(Exchange exchange) {
        Exchange orig = EXCHANGE.get();
        if (exchange != null) {
            EXCHANGE.set(exchange);
        } else {
            EXCHANGE.remove();
        }
        return orig;
    }

    public Context getContext() {
        return ExchangeProxy.getExchange().getContext();
    }

    public Context getContext(Message message) {
        return ExchangeProxy.getExchange().getContext(message);
    }

    public ServiceReference getConsumer() {
        return ExchangeProxy.getExchange().getConsumer();
    }

    public Service getProvider() {
        return ExchangeProxy.getExchange().getProvider();
    }

    public ExchangeContract getContract() {
        return ExchangeProxy.getExchange().getContract();
    }

    public Exchange consumer(ServiceReference consumer, ServiceOperation operation) {
        return this;
    }

    public Exchange provider(Service provider, ServiceOperation operation) {
        return this;
    }

    public Message getMessage() {
        return ExchangeProxy.getExchange().getMessage();
    }

    public Message createMessage() {
        return ExchangeProxy.getExchange().createMessage();
    }

    public void send(Message message) {
        ExchangeProxy.getExchange().send(message);
    }

    public void sendFault(Message message) {
        ExchangeProxy.getExchange().sendFault(message);
    }

    public ExchangeState getState() {
        return ExchangeProxy.getExchange().getState();
    }

    public ExchangePhase getPhase() {
        return ExchangeProxy.getExchange().getPhase();
    }

    public ExchangeHandler getReplyHandler() {
        return null;
    }

    public ExchangePattern getPattern() {
        return ExchangeProxy.getExchange().getPattern();
    }

    public ExchangeSecurity getSecurity() {
        return ExchangeProxy.getExchange().getSecurity();
    }
}

