/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.logging.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.http.ContentType;
import org.switchyard.component.http.HttpConsumeException;
import org.switchyard.component.http.HttpLogger;
import org.switchyard.component.http.HttpMessages;
import org.switchyard.component.http.composer.HttpBindingData;
import org.switchyard.component.http.composer.HttpComposition;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.component.http.config.model.HttpBindingModel;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.label.BehaviorLabel;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private static final String HTTP_GET = "GET";
    private static final String HTTP_POST = "POST";
    private static final String HTTP_DELETE = "DELETE";
    private static final String HTTP_HEAD = "HEAD";
    private static final String HTTP_PUT = "PUT";
    private static final String HTTP_OPTIONS = "OPTIONS";
    private static final Set<String> REQUEST_HEADER_BLACKLIST = new HashSet<String>(Arrays.asList("Content-Length", "Transfer-Encoding"));
    private static final String MAP_AUTH_SCOPE_KEY = "auth_scope";
    private static final String MAP_AUTH_CACHE_KEY = "auth_cache";
    private final HttpBindingModel _config;
    private final String _bindingName;
    private final String _referenceName;
    private MessageComposer<HttpBindingData> _messageComposer;
    private String _baseAddress = "http://localhost:8080";
    private String _httpMethod = "GET";
    private String _contentType;
    private AuthScope _authScope;
    private AuthCache _authCache;
    private Credentials _credentials;
    private HttpHost _proxyHost;
    private Integer _timeout;

    public OutboundHandler(HttpBindingModel config, ServiceDomain domain) {
        super(domain);
        this._config = config;
        this._bindingName = config.getName();
        this._referenceName = config.getReference().getName();
    }

    protected void doStart() throws HttpConsumeException {
        String contentType;
        String method;
        String address = this._config.getAddress();
        if (address != null) {
            this._baseAddress = address;
        }
        if ((method = this._config.getMethod()) != null) {
            this._httpMethod = method;
        }
        if ((contentType = this._config.getContentType()) != null) {
            this._contentType = contentType;
        }
        this._messageComposer = HttpComposition.getMessageComposer(this._config);
        if (this._config.hasAuthentication().booleanValue()) {
            if (this._config.isBasicAuth().booleanValue()) {
                this._authScope = this.createAuthScope(this._config.getBasicAuthConfig().getHost(), this._config.getBasicAuthConfig().getPort(), this._config.getBasicAuthConfig().getRealm(), this._baseAddress);
                this._credentials = new UsernamePasswordCredentials(this._config.getBasicAuthConfig().getUser(), this._config.getBasicAuthConfig().getPassword());
                this._authCache = new BasicAuthCache();
                this._authCache.put(new HttpHost(this._authScope.getHost(), this._authScope.getPort()), (AuthScheme)new BasicScheme(ChallengeState.TARGET));
            } else {
                this._authScope = this.createAuthScope(this._config.getNtlmAuthConfig().getHost(), this._config.getNtlmAuthConfig().getPort(), this._config.getNtlmAuthConfig().getRealm(), this._baseAddress);
                this._credentials = new NTCredentials(this._config.getNtlmAuthConfig().getUser(), this._config.getNtlmAuthConfig().getPassword(), "", this._config.getNtlmAuthConfig().getDomain());
            }
        }
        if (this._config.getProxyConfig() != null) {
            this._proxyHost = this._config.getProxyConfig().getPort() != null ? new HttpHost(this._config.getProxyConfig().getHost(), Integer.valueOf(this._config.getProxyConfig().getPort()).intValue()) : new HttpHost(this._config.getProxyConfig().getHost(), -1);
            if (this._config.getProxyConfig().getUser() != null) {
                this._authScope = this.createAuthScope(this._config.getProxyConfig().getHost(), this._config.getProxyConfig().getPort(), null, this._baseAddress);
                this._credentials = new UsernamePasswordCredentials(this._config.getProxyConfig().getUser(), this._config.getProxyConfig().getPassword());
                if (this._authCache == null) {
                    this._authCache = new BasicAuthCache();
                }
                this._authCache.put(this._proxyHost, (AuthScheme)new BasicScheme(ChallengeState.PROXY));
            }
        }
        this._timeout = this._config.getTimeout();
    }

    private AuthScope createAuthScope(String host, String portStr, String realm, String address) throws HttpConsumeException {
        URL url = null;
        try {
            url = new URL(address);
        }
        catch (MalformedURLException mue) {
            String m = HttpMessages.MESSAGES.invalidHttpURL();
            LOGGER.error((Object)m, (Throwable)mue);
            throw new HttpConsumeException(m, mue);
        }
        if (realm == null) {
            realm = AuthScope.ANY_REALM;
        }
        int port = url.getPort();
        if (host == null) {
            host = url.getHost();
        }
        if (portStr != null) {
            port = Integer.valueOf(portStr);
        }
        return new AuthScope(host, port, realm);
    }

    private Map<String, Object> composeAuthScope(String address) {
        HashMap<String, Object> authMap = new HashMap<String, Object>();
        AuthScope authScope = this._authScope;
        AuthCache authCache = this._authCache;
        if (this._config.hasAuthentication().booleanValue()) {
            if (this._config.isBasicAuth().booleanValue()) {
                authScope = this.createAuthScope(this._config.getBasicAuthConfig().getHost(), this._config.getBasicAuthConfig().getPort(), this._config.getBasicAuthConfig().getRealm(), address);
                authCache = new BasicAuthCache();
                authCache.put(new HttpHost(authScope.getHost(), authScope.getPort()), (AuthScheme)new BasicScheme(ChallengeState.TARGET));
            } else {
                authScope = this.createAuthScope(this._config.getNtlmAuthConfig().getHost(), this._config.getNtlmAuthConfig().getPort(), this._config.getNtlmAuthConfig().getRealm(), address);
            }
        }
        if (this._proxyHost != null && this._config.getProxyConfig().getUser() != null) {
            authScope = this.createAuthScope(this._config.getProxyConfig().getHost(), this._config.getProxyConfig().getPort(), null, address);
        }
        authMap.put(MAP_AUTH_CACHE_KEY, authCache);
        authMap.put(MAP_AUTH_SCOPE_KEY, authScope);
        return authMap;
    }

    private Map<String, String> decomposeQueryParams(String queryString) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (queryString != null && !queryString.isEmpty()) {
            String[] parametersArray;
            if (queryString.startsWith("?")) {
                queryString = queryString.substring(1);
            }
            if ((parametersArray = queryString.split("&")).length > 0) {
                for (String parameter_uri : parametersArray) {
                    String[] paramVal;
                    if (!parameter_uri.contains("=") || (paramVal = parameter_uri.split("=")).length != 2) continue;
                    params.put(paramVal[0], paramVal[1]);
                }
            }
        }
        return params;
    }

    private String composeAddress(Context context) {
        String uri;
        if (context.getProperty("CamelHttpUri") != null) {
            LOGGER.info((Object)("HTTP Outbound Handler Message Property Changed: URI=" + context.getProperty("CamelHttpUri").getValue()));
            uri = (String)context.getProperty("CamelHttpUri").getValue();
        } else {
            uri = this._baseAddress;
        }
        if (context.getProperty("CamelHttpQuery") != null) {
            LOGGER.info((Object)("HTTP Outbound Handler Message Property Changed: HttpQuery=" + context.getProperty("CamelHttpQuery").getValue()));
            String queryString = (String)context.getProperty("CamelHttpQuery").getValue();
            HashMap<String, String> params = new HashMap<String, String>();
            if (uri.contains("?")) {
                String uri_query = uri.substring(uri.lastIndexOf("?") + 1);
                params.putAll(this.decomposeQueryParams(uri_query));
            }
            params.putAll(this.decomposeQueryParams(queryString));
            String baseUri = uri.contains("?") ? uri.substring(0, uri.lastIndexOf("?")) : uri;
            if (params.size() > 0) {
                uri = baseUri + "?";
                int i = 0;
                for (String param_key : params.keySet()) {
                    uri = uri + param_key + "=" + (String)params.get(param_key);
                    if (i < params.size() - 1) {
                        uri = uri + "&";
                    }
                    ++i;
                }
            } else {
                uri = baseUri;
            }
            LOGGER.info((Object)("HTTP Outbound Handler Message Property Changed: ComposedURI=" + uri));
        }
        return uri;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._bindingName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        if (this.getState() != Lifecycle.State.STARTED) {
            String m = HttpMessages.MESSAGES.bindingNotStarted(this._referenceName, this._bindingName);
            LOGGER.error((Object)m);
            throw new HandlerException(m);
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        if (this._timeout != null) {
            HttpParams httpParams = httpclient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this._timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this._timeout);
        }
        try {
            Header[] headers;
            AuthCache authCache;
            AuthScope authScope;
            String address = this.composeAddress(exchange.getMessage().getContext());
            if (address.equals(this._baseAddress)) {
                authScope = this._authScope;
                authCache = this._authCache;
            } else {
                Map<String, Object> authValues = this.composeAuthScope(address);
                authCache = (AuthCache)authValues.get(MAP_AUTH_CACHE_KEY);
                authScope = (AuthScope)authValues.get(MAP_AUTH_SCOPE_KEY);
            }
            if (this._credentials != null) {
                httpclient.getCredentialsProvider().setCredentials(authScope, this._credentials);
                ArrayList<String> authpref = new ArrayList<String>();
                authpref.add("NTLM");
                authpref.add("Basic");
                httpclient.getParams().setParameter("http.auth.target-scheme-pref", authpref);
            }
            if (this._proxyHost != null) {
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)this._proxyHost);
            }
            HttpBindingData httpRequest = (HttpBindingData)this._messageComposer.decompose(exchange, (BindingData)new HttpRequestBindingData());
            HttpGet request = null;
            Property httpMethodProp = exchange.getMessage().getContext().getProperty("CamelHttpMethod");
            if (httpMethodProp != null && !httpMethodProp.getValue().equals("")) {
                String httpMethod = (String)httpMethodProp.getValue();
                LOGGER.info((Object)("HTTP Outbound Handler Message Property Changed: URL_Method=" + httpMethod));
                if (httpMethod.equals(HTTP_GET)) {
                    request = new HttpGet(address);
                } else if (httpMethod.equals(HTTP_POST)) {
                    request = new HttpPost(address);
                    ((HttpPost)request).setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)new InputStreamEntity((InputStream)httpRequest.getBodyBytes(), (long)httpRequest.getBodyBytes().available())));
                } else if (httpMethod.equals(HTTP_DELETE)) {
                    request = new HttpDelete(address);
                } else if (httpMethod.equals(HTTP_HEAD)) {
                    request = new HttpHead(address);
                } else if (httpMethod.equals(HTTP_PUT)) {
                    request = new HttpPut(address);
                    ((HttpPut)request).setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)new InputStreamEntity((InputStream)httpRequest.getBodyBytes(), (long)httpRequest.getBodyBytes().available())));
                } else if (httpMethod.equals(HTTP_OPTIONS)) {
                    request = new HttpOptions(address);
                }
            }
            if (request == null) {
                if (this._httpMethod.equals(HTTP_GET)) {
                    request = new HttpGet(address);
                } else if (this._httpMethod.equals(HTTP_POST)) {
                    request = new HttpPost(address);
                    ((HttpPost)request).setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)new InputStreamEntity((InputStream)httpRequest.getBodyBytes(), (long)httpRequest.getBodyBytes().available())));
                } else if (this._httpMethod.equals(HTTP_DELETE)) {
                    request = new HttpDelete(address);
                } else if (this._httpMethod.equals(HTTP_HEAD)) {
                    request = new HttpHead(address);
                } else if (this._httpMethod.equals(HTTP_PUT)) {
                    request = new HttpPut(address);
                    ((HttpPut)request).setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)new InputStreamEntity((InputStream)httpRequest.getBodyBytes(), (long)httpRequest.getBodyBytes().available())));
                } else if (this._httpMethod.equals(HTTP_OPTIONS)) {
                    request = new HttpOptions(address);
                }
            }
            for (Map.Entry<String, List<String>> entry : httpRequest.getHeaders().entrySet()) {
                String name = entry.getKey();
                if (REQUEST_HEADER_BLACKLIST.contains(name)) {
                    HttpLogger.ROOT_LOGGER.removingProhibitedRequestHeader(name);
                    continue;
                }
                List<String> values = entry.getValue();
                for (String value : values) {
                    request.addHeader(name, value);
                }
            }
            if (this._contentType != null) {
                request.addHeader("Content-Type", this._contentType);
            }
            HttpResponse response = null;
            if (this._credentials != null && this._credentials instanceof NTCredentials) {
                response = httpclient.execute((HttpUriRequest)new HttpGet(address));
                HttpClientUtils.closeQuietly((HttpResponse)response);
            }
            if (authCache != null) {
                BasicHttpContext context = new BasicHttpContext();
                context.setAttribute("http.auth.auth-cache", (Object)authCache);
                response = httpclient.execute((HttpUriRequest)request, (HttpContext)context);
            } else {
                response = httpclient.execute((HttpUriRequest)request);
            }
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            HttpResponseBindingData httpResponse = new HttpResponseBindingData();
            for (Header header : headers = response.getAllHeaders()) {
                httpResponse.addHeader(header.getName(), header.getValue());
            }
            if (entity != null) {
                if (entity.getContentType() != null) {
                    httpResponse.setContentType(new ContentType(entity.getContentType().getValue()));
                } else {
                    httpResponse.setContentType(new ContentType());
                }
                httpResponse.setBodyFromStream(entity.getContent());
            }
            httpResponse.setStatus(status);
            Message out = this._messageComposer.compose((BindingData)httpResponse, exchange);
            if (httpResponse.getStatus() < 400) {
                exchange.send(out);
            } else {
                exchange.sendFault(out);
            }
        }
        catch (Exception e) {
            String m = HttpMessages.MESSAGES.unexpectedExceptionHandlingHTTPMessage();
            LOGGER.error((Object)m, (Throwable)e);
            throw new HandlerException(m, (Throwable)e);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }
}

