/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.extensions.wsdl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.logging.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.extensions.wsdl.WSDLExtensionsMessages;
import org.switchyard.extensions.wsdl.WSDLReaderException;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.ServiceOperation;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLReader {
    private static final Logger LOGGER = Logger.getLogger(WSDLReader.class);
    private static final String SOAP11_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String SOAP12_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private static final String WSDLNS_URI = "http://schemas.xmlsoap.org/wsdl/";
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String ATTR_ELEMENT = "element";
    private static final String ATTR_LOCATION = "location";
    private static final String ATTR_MESSAGE = "message";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TARGET_NS = "targetNamespace";
    private static final String ATTR_XMLNS = "xmlns";
    private static final String ATTR_STYLE = "style";
    private static final String ATTR_TYPE = "type";
    private static final QName IMPORT = new QName("http://schemas.xmlsoap.org/wsdl/", "import");
    private static final QName PORT_TYPE = new QName("http://schemas.xmlsoap.org/wsdl/", "portType");
    private static final QName OPERATION = new QName("http://schemas.xmlsoap.org/wsdl/", "operation");
    private static final QName INPUT = new QName("http://schemas.xmlsoap.org/wsdl/", "input");
    private static final QName OUTPUT = new QName("http://schemas.xmlsoap.org/wsdl/", "output");
    private static final QName FAULT = new QName("http://schemas.xmlsoap.org/wsdl/", "fault");
    private static final QName MESSAGE = new QName("http://schemas.xmlsoap.org/wsdl/", "message");
    private static final QName PART = new QName("http://schemas.xmlsoap.org/wsdl/", "part");
    private static final QName BINDING = new QName("http://schemas.xmlsoap.org/wsdl/", "binding");
    private static final QName SOAP11_BINDING = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding");
    private static final QName SOAP12_BINDING = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "binding");
    private static final String DOCUMENT = "document";
    private static final String RESPONSE = "Response";
    private Boolean _documentStyle;
    private String _wsdlURI;

    public HashSet<ServiceOperation> readWSDL(String wsdlURI, String portName) throws WSDLReaderException {
        Map<String, String> namespaces;
        Element defEl = this.readWSDL(wsdlURI);
        Element portType = this.getPortType(defEl, portName, namespaces = this.parseNamespaces(defEl));
        if (portType == null) {
            throw WSDLExtensionsMessages.MESSAGES.unableFindPort(portName);
        }
        String style = this.getStyle(defEl, portType, namespaces);
        this._documentStyle = style.equals(DOCUMENT);
        Map<QName, QName> parts = this.getParts(defEl, portType, namespaces);
        HashSet<ServiceOperation> ops = new HashSet<ServiceOperation>();
        List<Element> operations = this.getOperations(portType);
        int size = operations.size();
        for (int i = 0; i < size; ++i) {
            ops.add(this.createServiceOperation(operations.get(i), parts, namespaces));
        }
        return ops;
    }

    public Element readWSDL(String wsdlURI) throws WSDLReaderException {
        try {
            if (this._wsdlURI == null) {
                this._wsdlURI = wsdlURI;
            }
            LOGGER.trace((Object)("Retrieving document at '" + wsdlURI + "'"));
            URL url = this.getURL(wsdlURI);
            InputStream inputStream = url.openStream();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(url.toString());
            Document doc = XMLHelper.getDocument((InputSource)inputSource);
            inputStream.close();
            return doc.getDocumentElement();
        }
        catch (IOException e) {
            throw WSDLExtensionsMessages.MESSAGES.unableResolveWSDL(wsdlURI, e);
        }
        catch (ParserConfigurationException pce) {
            throw new WSDLReaderException(pce);
        }
        catch (SAXException se) {
            throw new WSDLReaderException(se);
        }
    }

    private List<String> getImports(Element defEl) {
        Element tempEl = XMLHelper.getFirstChildElement((Node)defEl);
        ArrayList<String> imports = new ArrayList<String>();
        while (tempEl != null) {
            QName qname = new QName(tempEl.getNamespaceURI(), tempEl.getLocalName());
            if (IMPORT.equals(qname)) {
                imports.add(tempEl.getAttribute(ATTR_LOCATION));
            }
            tempEl = XMLHelper.getNextSiblingElement((Node)tempEl);
        }
        return imports;
    }

    private Element getPortType(Element defEl, String portName, Map<String, String> namespaces) throws WSDLReaderException {
        Element tempEl = XMLHelper.getFirstChildElement((Node)defEl);
        Element portType = null;
        while (tempEl != null) {
            QName qname = new QName(tempEl.getNamespaceURI(), tempEl.getLocalName());
            if (PORT_TYPE.equals(qname)) {
                if (portName != null && tempEl.hasAttribute(ATTR_NAME) && !tempEl.getAttribute(ATTR_NAME).equals(portName)) {
                    tempEl = XMLHelper.getNextSiblingElement((Node)tempEl);
                    continue;
                }
                portType = tempEl;
                break;
            }
            tempEl = XMLHelper.getNextSiblingElement((Node)tempEl);
        }
        if (portType == null) {
            List<String> wsdlImports = this.getImports(defEl);
            int size = wsdlImports.size();
            for (int i = 0; i < size; ++i) {
                Element importedDefEl = this.readWSDL(wsdlImports.get(i));
                namespaces.putAll(this.parseNamespaces(importedDefEl));
                portType = this.getPortType(importedDefEl, portName, namespaces);
                if (portType != null) break;
            }
        }
        return portType;
    }

    private String getStyle(Element defEl, Element portType, Map<String, String> namespaces) throws WSDLReaderException {
        Element tempEl = XMLHelper.getFirstChildElement((Node)defEl);
        QName portTypeName = this.getQName(portType.getAttributeNode(ATTR_NAME).getValue(), namespaces);
        String style = DOCUMENT;
        block0: while (tempEl != null) {
            QName bindingType;
            QName qname = new QName(tempEl.getNamespaceURI(), tempEl.getLocalName());
            if (BINDING.equals(qname) && (bindingType = this.getQName(tempEl.getAttributeNode(ATTR_TYPE).getValue(), namespaces)).equals(portTypeName)) {
                Element tempEl2 = XMLHelper.getFirstChildElement((Node)tempEl);
                while (tempEl2 != null) {
                    QName qname2 = new QName(tempEl2.getNamespaceURI(), tempEl2.getLocalName());
                    if ((SOAP11_BINDING.equals(qname2) || SOAP12_BINDING.equals(qname2)) && tempEl2.hasAttribute(ATTR_STYLE)) {
                        style = tempEl2.getAttributeNode(ATTR_STYLE).getValue();
                        break block0;
                    }
                    tempEl2 = XMLHelper.getNextSiblingElement((Node)tempEl2);
                }
                break;
            }
            tempEl = XMLHelper.getNextSiblingElement((Node)tempEl);
        }
        if (style == null) {
            List<String> wsdlImports = this.getImports(defEl);
            int size = wsdlImports.size();
            for (int i = 0; i < size; ++i) {
                Element importedDefEl = this.readWSDL(wsdlImports.get(i));
                namespaces.putAll(this.parseNamespaces(importedDefEl));
                style = this.getStyle(importedDefEl, portType, namespaces);
                if (style != null) break;
            }
        }
        return style;
    }

    private List<Element> getOperations(Element portEl) {
        Element tempEl = XMLHelper.getFirstChildElement((Node)portEl);
        ArrayList<Element> operations = new ArrayList<Element>();
        while (tempEl != null) {
            QName qname = new QName(tempEl.getNamespaceURI(), tempEl.getLocalName());
            if (OPERATION.equals(qname)) {
                operations.add(tempEl);
            }
            tempEl = XMLHelper.getNextSiblingElement((Node)tempEl);
        }
        return operations;
    }

    private Element getOperationByInput(Element portEl, Element msgEl, Map<String, String> namespaces) {
        Element tempEl = XMLHelper.getFirstChildElement((Node)portEl);
        Element operation = null;
        QName msgQName = this.getQName(msgEl.getAttribute(ATTR_NAME), namespaces);
        block0: while (tempEl != null) {
            QName qname = new QName(tempEl.getNamespaceURI(), tempEl.getLocalName());
            if (OPERATION.equals(qname)) {
                Element inputEl = XMLHelper.getFirstChildElement((Node)tempEl);
                while (inputEl != null) {
                    QName inputMessageQName;
                    QName inputElQName = new QName(inputEl.getNamespaceURI(), inputEl.getLocalName());
                    if (INPUT.equals(inputElQName) && (inputMessageQName = this.getQName(inputEl.getAttribute(ATTR_MESSAGE), namespaces)).equals(msgQName)) {
                        operation = tempEl;
                        break block0;
                    }
                    inputEl = XMLHelper.getNextSiblingElement((Node)inputEl);
                }
            }
            tempEl = XMLHelper.getNextSiblingElement((Node)tempEl);
        }
        return operation;
    }

    private Element getOperationByOutput(Element portEl, Element msgEl, Map<String, String> namespaces) {
        Element tempEl = XMLHelper.getFirstChildElement((Node)portEl);
        Element operation = null;
        QName msgQName = this.getQName(msgEl.getAttribute(ATTR_NAME), namespaces);
        block0: while (tempEl != null) {
            QName qname = new QName(tempEl.getNamespaceURI(), tempEl.getLocalName());
            if (OPERATION.equals(qname)) {
                Element inputEl = XMLHelper.getFirstChildElement((Node)tempEl);
                while (inputEl != null) {
                    QName inputMessageQName;
                    QName inputElQName = new QName(inputEl.getNamespaceURI(), inputEl.getLocalName());
                    if (OUTPUT.equals(inputElQName) && (inputMessageQName = this.getQName(inputEl.getAttribute(ATTR_MESSAGE), namespaces)).equals(msgQName)) {
                        operation = tempEl;
                        break block0;
                    }
                    inputEl = XMLHelper.getNextSiblingElement((Node)inputEl);
                }
            }
            tempEl = XMLHelper.getNextSiblingElement((Node)tempEl);
        }
        return operation;
    }

    private Map<QName, QName> getParts(Element defEl, Element portType, Map<String, String> namespaces) throws WSDLReaderException {
        HashSet<QName> messagesInUse = new HashSet<QName>();
        NodeList inputs = portType.getElementsByTagNameNS(INPUT.getNamespaceURI(), INPUT.getLocalPart());
        for (int i = 0; i < inputs.getLength(); ++i) {
            NamedNodeMap attrs = inputs.item(i).getAttributes();
            Node message = attrs.getNamedItem(ATTR_MESSAGE);
            messagesInUse.add(this.getQName(message.getNodeValue(), namespaces));
        }
        NodeList outputs = portType.getElementsByTagNameNS(OUTPUT.getNamespaceURI(), OUTPUT.getLocalPart());
        for (int i = 0; i < outputs.getLength(); ++i) {
            NamedNodeMap attrs = outputs.item(i).getAttributes();
            Node message = attrs.getNamedItem(ATTR_MESSAGE);
            messagesInUse.add(this.getQName(message.getNodeValue(), namespaces));
        }
        NodeList faults = portType.getElementsByTagNameNS(FAULT.getNamespaceURI(), FAULT.getLocalPart());
        for (int i = 0; i < faults.getLength(); ++i) {
            NamedNodeMap attrs = faults.item(i).getAttributes();
            Node message = attrs.getNamedItem(ATTR_MESSAGE);
            messagesInUse.add(this.getQName(message.getNodeValue(), namespaces));
        }
        NodeList messages = defEl.getElementsByTagNameNS(MESSAGE.getNamespaceURI(), MESSAGE.getLocalPart());
        int msgSize = messages.getLength();
        Map<QName, QName> parts = new HashMap<QName, QName>();
        for (int i = 0; i < msgSize; ++i) {
            Element msgEl = (Element)messages.item(i);
            QName name = this.getQName(msgEl.getAttribute(ATTR_NAME), namespaces);
            if (!messagesInUse.contains(name)) continue;
            NodeList partEls = msgEl.getElementsByTagNameNS(PART.getNamespaceURI(), PART.getLocalPart());
            if (this._documentStyle.booleanValue() && partEls.getLength() != 1) {
                throw WSDLExtensionsMessages.MESSAGES.wsdlInterfaceNeedsOneParameter();
            }
            if (this._documentStyle.booleanValue()) {
                Element partEl = (Element)partEls.item(0);
                parts.put(this.getQName(msgEl.getAttribute(ATTR_NAME), namespaces), this.getQName(partEl.getAttribute(ATTR_ELEMENT), namespaces));
                continue;
            }
            if (!msgEl.hasAttribute(ATTR_NAME)) {
                throw WSDLExtensionsMessages.MESSAGES.messageNameMissing();
            }
            Element operationEl = this.getOperationByInput(portType, msgEl, namespaces);
            if (operationEl != null) {
                parts.put(this.getQName(msgEl.getAttribute(ATTR_NAME), namespaces), this.getQName(operationEl.getAttribute(ATTR_NAME), namespaces));
                continue;
            }
            operationEl = this.getOperationByOutput(portType, msgEl, namespaces);
            if (operationEl != null) {
                parts.put(this.getQName(msgEl.getAttribute(ATTR_NAME), namespaces), this.getQName(operationEl.getAttribute(ATTR_NAME) + RESPONSE, namespaces));
                continue;
            }
            WSDLExtensionsMessages.MESSAGES.missingOperationForMessage(msgEl.getLocalName());
        }
        if (parts.isEmpty()) {
            List<String> wsdlImports = this.getImports(defEl);
            int size = wsdlImports.size();
            for (int i = 0; i < size; ++i) {
                Element importedDefEl = this.readWSDL(wsdlImports.get(i));
                namespaces.putAll(this.parseNamespaces(importedDefEl));
                parts = this.getParts(importedDefEl, portType, namespaces);
                if (!parts.isEmpty()) break;
            }
        }
        return parts;
    }

    private ServiceOperation createServiceOperation(Element opEl, Map<QName, QName> parts, Map<String, String> namespaces) {
        Element tempEl = XMLHelper.getFirstChildElement((Node)opEl);
        QName inputType = null;
        QName outputType = null;
        QName faultType = null;
        while (tempEl != null) {
            QName qname = new QName(tempEl.getNamespaceURI(), tempEl.getLocalName());
            if (INPUT.equals(qname)) {
                inputType = parts.get(this.getQName(tempEl.getAttribute(ATTR_MESSAGE), namespaces));
            } else if (OUTPUT.equals(qname)) {
                outputType = parts.get(this.getQName(tempEl.getAttribute(ATTR_MESSAGE), namespaces));
            } else if (FAULT.equals(qname)) {
                faultType = parts.get(this.getQName(tempEl.getAttribute(ATTR_MESSAGE), namespaces));
            }
            tempEl = XMLHelper.getNextSiblingElement((Node)tempEl);
        }
        if (outputType == null) {
            return new InOnlyOperation(opEl.getAttribute(ATTR_NAME), inputType);
        }
        return new InOutOperation(opEl.getAttribute(ATTR_NAME), inputType, outputType, faultType);
    }

    private Map<String, String> parseNamespaces(Element defEl) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        String targetNamespace = defEl.getAttribute(ATTR_TARGET_NS);
        namespaces.put(null, targetNamespace);
        NamedNodeMap attrs = defEl.getAttributes();
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String namespaceURI = attr.getNamespaceURI();
            String localPart = attr.getLocalName();
            String value = attr.getValue();
            if (namespaceURI == null || !namespaceURI.equals(XMLNS_URI) || localPart == null || localPart.equals(ATTR_XMLNS)) continue;
            namespaces.put(localPart, value);
        }
        return namespaces;
    }

    private QName getQName(String value, Map<String, String> namespaces) {
        String name = null;
        String namespace = null;
        if (value != null) {
            int idx = value.lastIndexOf(":");
            name = value.substring(idx + 1, value.length());
            if (idx > 0) {
                namespace = value.substring(0, idx);
            }
        }
        return new QName(namespaces.get(namespace), name);
    }

    private URL getURL(String path) throws MalformedURLException {
        URL url;
        if (path.startsWith("http://") || path.startsWith("https://") || path.startsWith("file://")) {
            return new URL(null, path);
        }
        try {
            url = this._wsdlURI.equals(path) ? Classes.getResource((String)path, this.getClass()) : Classes.getResource((String)this.createRelativePath(this._wsdlURI, path), this.getClass());
        }
        catch (IOException ioe) {
            url = null;
        }
        if (url == null) {
            File localFile = new File(path);
            url = localFile.toURI().toURL();
        }
        return url;
    }

    String createRelativePath(String baseURI, String path) {
        int lastPathIdx = baseURI.lastIndexOf(47);
        if (lastPathIdx > 0) {
            return baseURI.substring(0, lastPathIdx + 1) + path;
        }
        return path;
    }
}

