/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import java.util.HashSet;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.WeldStartService;
import org.jboss.as.weld.services.BeanManagerService;
import org.jboss.logging.Logger;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.switchyard.as7.extension.SwitchYardDeploymentMarker;
import org.switchyard.as7.extension.SwitchYardModuleAdd;
import org.switchyard.as7.extension.deployment.SwitchYardDeployment;
import org.switchyard.as7.extension.deployment.SwitchYardMetaData;
import org.switchyard.as7.extension.services.SwitchYardComponentService;
import org.switchyard.as7.extension.services.SwitchYardService;
import org.switchyard.as7.extension.services.SwitchYardServiceDomainManagerService;
import org.switchyard.component.jca.config.model.InboundConnectionModel;
import org.switchyard.component.jca.config.model.JCABindingModel;
import org.switchyard.component.jca.config.model.OutboundConnectionModel;
import org.switchyard.component.jca.config.model.ResourceAdapterModel;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.deploy.Component;
import org.switchyard.deploy.ServiceDomainManager;

public class SwitchYardDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        EarMetaData earConfig;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!SwitchYardDeploymentMarker.isSwitchYardDeployment(deploymentUnit)) {
            return;
        }
        DeploymentUnit parent = deploymentUnit.getParent();
        Boolean initializeInOrder = false;
        if (parent != null && (earConfig = (EarMetaData)deploymentUnit.getParent().getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA)) != null) {
            initializeInOrder = earConfig.getInitializeInOrder();
        }
        this.doDeploy(phaseContext, deploymentUnit, initializeInOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeploy(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, Boolean initializeInOrder) {
        LOG.info((Object)("Deploying SwitchYard application '" + deploymentUnit.getName() + "'"));
        ServiceDomainManager domainManager = (ServiceDomainManager)phaseContext.getServiceRegistry().getRequiredService(SwitchYardServiceDomainManagerService.SERVICE_NAME).getService().getValue();
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        SwitchYardMetaData metaData = (SwitchYardMetaData)deploymentUnit.getAttachment(SwitchYardMetaData.ATTACHMENT_KEY);
        SwitchYardDeployment deployment = new SwitchYardDeployment(deploymentUnit, metaData.getSwitchYardModel(), domainManager);
        SwitchYardService container = new SwitchYardService(deployment);
        ServiceName switchyardServiceName = deploymentUnit.getServiceName().append(SwitchYardService.SERVICE_NAME);
        ServiceBuilder switchyardServiceBuilder = serviceTarget.addService(switchyardServiceName, (Service)container);
        for (String componentName : SwitchYardModuleAdd.getComponentNames()) {
            switchyardServiceBuilder.addDependency(SwitchYardComponentService.SERVICE_NAME.append(new String[]{componentName}), Component.class, container.getComponent());
        }
        switchyardServiceBuilder.addDependency(JndiNamingDependencyProcessor.serviceName((DeploymentUnit)deploymentUnit));
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription != null) {
            container.getNamespaceSelector().setValue((Value)new ImmediateValue((Object)moduleDescription.getNamespaceContextSelector()));
        }
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            ServiceName weldStartServiceName;
            ServiceName beanManagerServiceName = deploymentUnit.getServiceName().append(BeanManagerService.NAME);
            switchyardServiceBuilder.addDependency(beanManagerServiceName);
            if (deploymentUnit.getParent() == null) {
                weldStartServiceName = deploymentUnit.getServiceName().append(WeldStartService.SERVICE_NAME);
                switchyardServiceBuilder.addDependency(weldStartServiceName);
            } else {
                weldStartServiceName = deploymentUnit.getParent().getServiceName().append(WeldStartService.SERVICE_NAME);
                switchyardServiceBuilder.addDependency(weldStartServiceName);
            }
        }
        HashSet<String> resourceAdapters = new HashSet<String>();
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        try {
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            CompositeModel composite = metaData.getSwitchYardModel().getComposite();
            if (composite != null) {
                ResourceAdapterModel ra;
                JCABindingModel jcabinding;
                for (CompositeServiceModel service : composite.getServices()) {
                    for (BindingModel binding : service.getBindings()) {
                        InboundConnectionModel ic;
                        if (!(binding instanceof JCABindingModel) || (ic = (jcabinding = (JCABindingModel)JCABindingModel.class.cast(binding)).getInboundConnection()) == null || (ra = ic.getResourceAdapter()) == null || ra.getName() == null || ra.getName().isEmpty()) continue;
                        resourceAdapters.add(ra.getName());
                    }
                }
                for (CompositeReferenceModel reference : composite.getReferences()) {
                    for (BindingModel binding : reference.getBindings()) {
                        OutboundConnectionModel oc;
                        if (!(binding instanceof JCABindingModel) || (oc = (jcabinding = (JCABindingModel)JCABindingModel.class.cast(binding)).getOutboundConnection()) == null || (ra = oc.getResourceAdapter()) == null || ra.getName() == null || ra.getName().isEmpty()) continue;
                        resourceAdapters.add(ra.getName());
                    }
                }
            } else {
                LOG.info((Object)"A composite element is missing from the switchyard.xml");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
        }
        for (String raName : resourceAdapters) {
            switchyardServiceBuilder.addDependency(ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{this.stripDotRarSuffix(raName)}));
        }
        if (initializeInOrder.booleanValue()) {
            DeploymentUnit parent = deploymentUnit.getParent();
            ServiceName previousServiceName = (ServiceName)parent.getAttachment(SwitchYardMetaData.SERVICENAME_ATTACHMENT_KEY);
            if (previousServiceName != null) {
                switchyardServiceBuilder.addDependency(previousServiceName);
            }
            parent.putAttachment(SwitchYardMetaData.SERVICENAME_ATTACHMENT_KEY, (Object)switchyardServiceName);
        }
        switchyardServiceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, CacheService.getServiceName((String)"cluster", null));
        switchyardServiceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.of((String[])new String[]{"jboss.messaging.default"}));
        switchyardServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        switchyardServiceBuilder.install();
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

