/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.camel;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.switchyard.common.camel.CdiManagerHelper;

public class CdiBeanRegistry
implements Registry {
    private static final AnnotationLiteral<Any> ANY = new AnnotationLiteral<Any>(){};
    private final BeanManager manager;

    CdiBeanRegistry(BeanManager manager) {
        this.manager = manager;
    }

    public Object lookupByName(String name) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        if ("properties".equals(name) && this.findByTypeWithName(PropertiesComponent.class).containsKey("properties")) {
            return CdiManagerHelper.getReferenceByName(this.manager, name, PropertiesComponent.class);
        }
        return CdiManagerHelper.getReferenceByName(this.manager, name, Object.class);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        ObjectHelper.notNull(type, (String)"type");
        return CdiManagerHelper.getReferenceByName(this.manager, name, type);
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        HashMap<String, T> references = new HashMap<String, T>();
        for (Bean bean : this.manager.getBeans(type, new Annotation[]{ANY})) {
            if (bean.getName() == null) continue;
            references.put(bean.getName(), CdiManagerHelper.getReference(this.manager, type, bean));
        }
        return references;
    }

    public <T> Set<T> findByType(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        return CdiManagerHelper.getReferencesByType(this.manager, type, new Annotation[]{ANY});
    }

    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.findByTypeWithName(type);
    }
}

