/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Providers;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.client.core.ClientInterceptorRepositoryImpl;
import org.jboss.resteasy.client.core.ClientInvokerInterceptorFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.client.core.extractors.ClientErrorHandler;
import org.jboss.resteasy.client.core.extractors.ClientRequestContext;
import org.jboss.resteasy.client.core.extractors.DefaultEntityExtractorFactory;
import org.jboss.resteasy.client.core.extractors.EntityExtractor;
import org.jboss.resteasy.client.core.extractors.EntityExtractorFactory;
import org.jboss.resteasy.client.core.marshallers.ClientMarshallerFactory;
import org.jboss.resteasy.client.core.marshallers.Marshaller;
import org.jboss.resteasy.client.exception.mapper.ApacheHttpClient4ExceptionMapper;
import org.jboss.resteasy.client.exception.mapper.ClientExceptionMapper;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.IsHttpMethod;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.Types;
import org.switchyard.Exchange;
import org.switchyard.SwitchYardException;
import org.switchyard.component.resteasy.RestEasyLogger;
import org.switchyard.component.resteasy.RestEasyMessages;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;
import org.switchyard.component.resteasy.config.model.ProxyModel;
import org.switchyard.component.resteasy.config.model.RESTEasyBindingModel;
import org.switchyard.component.resteasy.config.model.SSLContextModel;
import org.switchyard.component.resteasy.util.MethodInvoker;
import org.switchyard.component.resteasy.util.RESTEasyProxy;
import org.switchyard.component.resteasy.util.RESTEasyUtil;

public class ClientInvoker
extends ClientInterceptorRepositoryImpl
implements MethodInvoker {
    public static final String CONTEXT_PROPERTY_PREFIX = "org.switchyard.component.resteasy.";
    public static final String KEY_ADDRESS = "address";
    private static final Logger LOGGER = Logger.getLogger(ClientInvoker.class);
    private static final String AS7_URIBUILDER = "org.jboss.resteasy.specimpl.UriBuilderImpl";
    private static final String WFLY_URIBUILDER = "org.jboss.resteasy.specimpl.ResteasyUriBuilder";
    private static final String ANY = "ANY";
    private static final String BROWSER = "BROWSER";
    private static final String STRICT = "STRICT";
    private static Class<?> URIBUILDER_CLASS = null;
    private String _subResourcePath;
    private Class<?> _resourceClass;
    private Method _method;
    private String _httpMethod;
    private UriBuilder _defaultUriBuilder;
    private MediaType _accepts;
    private Marshaller[] _marshallers;
    private ClientExecutor _executor;
    private boolean _followRedirects;
    private EntityExtractor _extractor;
    private EntityExtractorFactory _extractorFactory;
    private ResteasyProviderFactory _providerFactory;
    private URI _baseUri;
    private Map<String, Object> _attributes = new HashMap<String, Object>();

    private static URI createUri(String base) {
        try {
            return new URI(base);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientInvoker(String basePath, Class<?> resourceClass, Method method) {
        this(basePath, resourceClass, method, null);
    }

    public ClientInvoker(String basePath, Class<?> resourceClass, Method method, RESTEasyBindingModel model) {
        Set httpMethods = IsHttpMethod.getHttpMethods((Method)method);
        this._baseUri = ClientInvoker.createUri(basePath);
        if ((httpMethods == null || httpMethods.size() == 0) && method.isAnnotationPresent(Path.class) && method.getReturnType().isInterface()) {
            this._subResourcePath = ClientInvoker.createSubResourcePath(basePath, method);
        } else if (httpMethods == null || httpMethods.size() != 1) {
            throw RestEasyMessages.MESSAGES.youMustUseAtLeastOneButNoMoreThanOneHttpMethodAnnotationOn(method.toString());
        }
        this._httpMethod = (String)httpMethods.iterator().next();
        this._resourceClass = resourceClass;
        this._method = method;
        this._defaultUriBuilder = this.createUriBuilder(this._baseUri, this._resourceClass, this._method);
        this._providerFactory = new ResteasyProviderFactory();
        SSLSocketFactory sslFactory = this.getSSLSocketFactory(model.getSSLContextConfig());
        if (sslFactory == null) {
            sslFactory = SSLSocketFactory.getSocketFactory();
        }
        boolean useBuiltins = true;
        if (model.getContextParamsConfig() != null) {
            List<ClientErrorInterceptor> interceptors;
            List<Class<?>> providerClasses;
            Map<String, String> contextParams = model.getContextParamsConfig().toMap();
            String registerBuiltins = contextParams.get("resteasy.use.builtin.providers");
            if (registerBuiltins != null) {
                useBuiltins = Boolean.parseBoolean(registerBuiltins);
            }
            if ((providerClasses = RESTEasyUtil.getProviderClasses(contextParams)) != null) {
                for (Class<?> pc : providerClasses) {
                    this._providerFactory.registerProvider(pc);
                }
            }
            if ((interceptors = RESTEasyUtil.getClientErrorInterceptors(contextParams)) != null) {
                for (ClientErrorInterceptor interceptor : interceptors) {
                    this._providerFactory.addClientErrorInterceptor(interceptor);
                }
            }
        }
        if (useBuiltins) {
            this._providerFactory.setRegisterBuiltins(true);
            RegisterBuiltin.register((ResteasyProviderFactory)this._providerFactory);
        }
        this._extractorFactory = new DefaultEntityExtractorFactory();
        this._extractor = this._extractorFactory.createExtractor(this._method);
        this._marshallers = ClientMarshallerFactory.createMarshallers(this._resourceClass, (Method)this._method, (ResteasyProviderFactory)this._providerFactory, null);
        this._accepts = MediaTypeHelper.getProduces(this._resourceClass, (Method)method, null);
        ClientInvokerInterceptorFactory.applyDefaultInterceptors((ClientInterceptorRepositoryImpl)this, (ResteasyProviderFactory)this._providerFactory, this._resourceClass, (Method)this._method);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        int port = this._baseUri.getPort();
        if (this._baseUri.getScheme().startsWith("https")) {
            if (port == -1) {
                port = 443;
            }
            schemeRegistry.register(new Scheme(this._baseUri.getScheme(), port, (SchemeSocketFactory)sslFactory));
        } else {
            if (port == -1) {
                port = 80;
            }
            schemeRegistry.register(new Scheme(this._baseUri.getScheme(), port, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        }
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
        this._executor = new ApacheHttpClient4Executor((HttpClient)httpClient);
        Type exceptionType = Types.getActualTypeArgumentsOfAnInterface(ApacheHttpClient4ExceptionMapper.class, ClientExceptionMapper.class)[0];
        this._providerFactory.addClientExceptionMapper((ClientExceptionMapper)new ApacheHttpClient4ExceptionMapper(), exceptionType);
        if (model.hasAuthentication().booleanValue()) {
            AuthScope authScope = null;
            UsernamePasswordCredentials credentials = null;
            if (model.isBasicAuth().booleanValue()) {
                authScope = this.createAuthScope(model.getBasicAuthConfig().getHost(), model.getBasicAuthConfig().getPort(), model.getBasicAuthConfig().getRealm());
                credentials = new UsernamePasswordCredentials(model.getBasicAuthConfig().getUser(), model.getBasicAuthConfig().getPassword());
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(new HttpHost(authScope.getHost(), authScope.getPort()), (AuthScheme)new BasicScheme(ChallengeState.TARGET));
                BasicHttpContext context = new BasicHttpContext();
                context.setAttribute("http.auth.auth-cache", (Object)authCache);
                ((ApacheHttpClient4Executor)this._executor).setHttpContext((HttpContext)context);
            } else {
                authScope = this.createAuthScope(model.getNtlmAuthConfig().getHost(), model.getNtlmAuthConfig().getPort(), model.getNtlmAuthConfig().getRealm());
                credentials = new NTCredentials(model.getNtlmAuthConfig().getUser(), model.getNtlmAuthConfig().getPassword(), "", model.getNtlmAuthConfig().getDomain());
            }
            httpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
        } else {
            ProxyModel proxy = model.getProxyConfig();
            if (proxy != null) {
                HttpHost proxyHost = null;
                proxyHost = proxy.getPort() != null ? new HttpHost(proxy.getHost(), Integer.valueOf(proxy.getPort()).intValue()) : new HttpHost(proxy.getHost(), -1);
                if (proxy.getUser() != null) {
                    AuthScope authScope = new AuthScope(proxy.getHost(), Integer.valueOf(proxy.getPort()).intValue(), AuthScope.ANY_REALM);
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxy.getUser(), proxy.getPassword());
                    BasicAuthCache authCache = new BasicAuthCache();
                    authCache.put(proxyHost, (AuthScheme)new BasicScheme(ChallengeState.PROXY));
                    httpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
                    BasicHttpContext context = new BasicHttpContext();
                    context.setAttribute("http.auth.auth-cache", (Object)authCache);
                    ((ApacheHttpClient4Executor)this._executor).setHttpContext((HttpContext)context);
                }
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
                int portSchema = proxyHost.getPort();
                if (proxyHost.getSchemeName().startsWith("https")) {
                    if (portSchema == -1) {
                        portSchema = 443;
                    }
                    schemeRegistry.register(new Scheme(proxyHost.getSchemeName(), portSchema, (SchemeSocketFactory)sslFactory));
                } else {
                    if (portSchema == -1) {
                        portSchema = 80;
                    }
                    schemeRegistry.register(new Scheme(proxyHost.getSchemeName(), portSchema, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
                }
            }
        }
        Integer timeout = model.getTimeout();
        if (timeout != null) {
            HttpParams httpParams = httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeout);
        }
    }

    private UriBuilder createUriBuilder(URI baseUri, Class<?> resourceClass, Method method) {
        UriBuilder builder = null;
        try {
            builder = (UriBuilder)URIBUILDER_CLASS.newInstance();
        }
        catch (Exception ie) {
            throw new SwitchYardException((Throwable)ie);
        }
        builder.uri(baseUri);
        if (resourceClass.isAnnotationPresent(Path.class)) {
            builder.path(resourceClass);
        }
        if (this._method.isAnnotationPresent(Path.class)) {
            builder.path(method);
        }
        return builder;
    }

    void setClientExecutor(ClientExecutor executor) {
        this._executor = executor;
    }

    public ResteasyProviderFactory getResteasyProviderFactory() {
        return this._providerFactory;
    }

    private SSLSocketFactory getSSLSocketFactory(SSLContextModel sslContextConfig) {
        SSLSocketFactory sslFactory = null;
        if (sslContextConfig != null) {
            FileInputStream instream;
            AllowAllHostnameVerifier verifier = null;
            if (sslContextConfig.getVerifier() != null) {
                if (sslContextConfig.getVerifier().equals(ANY)) {
                    verifier = new AllowAllHostnameVerifier();
                } else if (sslContextConfig.getVerifier().equals(BROWSER)) {
                    verifier = new BrowserCompatHostnameVerifier();
                } else if (sslContextConfig.getVerifier().equals(STRICT)) {
                    verifier = new StrictHostnameVerifier();
                }
            }
            KeyStore truststore = null;
            KeyStore keystore = null;
            if (sslContextConfig.getTruststore() != null) {
                instream = null;
                try {
                    truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                    instream = new FileInputStream(new File(sslContextConfig.getTruststore()));
                    truststore.load(instream, sslContextConfig.getTruststorePass().toCharArray());
                }
                catch (Exception e) {
                    throw RestEasyMessages.MESSAGES.unexpectedExceptionLoadingTruststore(e);
                }
                finally {
                    if (instream != null) {
                        try {
                            instream.close();
                        }
                        catch (IOException ioe) {
                            throw RestEasyMessages.MESSAGES.unexpectedExceptionClosingTruststore(ioe);
                        }
                    }
                }
            }
            if (sslContextConfig.getKeystore() != null) {
                instream = null;
                try {
                    keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    instream = new FileInputStream(new File(sslContextConfig.getKeystore()));
                    keystore.load(instream, sslContextConfig.getKeystorePass().toCharArray());
                }
                catch (Exception e) {
                    throw RestEasyMessages.MESSAGES.unexpectedExceptionLoadingKeystore(e);
                }
                finally {
                    if (instream != null) {
                        try {
                            instream.close();
                        }
                        catch (IOException ioe) {
                            throw RestEasyMessages.MESSAGES.unexpectedExceptionClosingKeystore(ioe);
                        }
                    }
                }
            }
            try {
                sslFactory = new SSLSocketFactory("TLS", keystore, sslContextConfig.getKeystorePass(), truststore, null, (X509HostnameVerifier)verifier);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sslFactory;
    }

    private AuthScope createAuthScope(String host, String portStr, String realm) throws RuntimeException {
        if (realm == null) {
            realm = AuthScope.ANY_REALM;
        }
        int port = -1;
        if (portStr != null) {
            port = Integer.valueOf(portStr);
        }
        return new AuthScope(host, port, realm);
    }

    private static String createSubResourcePath(String base, Method method) {
        String path;
        if (!base.endsWith("/")) {
            base = base + "/";
        }
        if ((path = method.getAnnotation(Path.class).value()).startsWith("/")) {
            path = path.substring(1);
        }
        Annotation[][] params = method.getParameterAnnotations();
        int index = 1;
        Annotation[][] arr$ = params;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] param;
            for (Annotation a : param = arr$[i$]) {
                if (!(a instanceof PathParam)) continue;
                String name = ((PathParam)a).value();
                path = path.replace("{" + name + "}", "%" + index + "$s");
                break;
            }
            ++index;
        }
        return base + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RESTEasyBindingData invoke(Exchange exchange, Object[] args, MultivaluedMap<String, String> headers) {
        boolean isProvidersSet;
        boolean bl = isProvidersSet = ResteasyProviderFactory.getContextData(Providers.class) != null;
        if (!isProvidersSet) {
            ResteasyProviderFactory.pushContext(Providers.class, (Object)this._providerFactory);
        }
        try {
            if (this._defaultUriBuilder == null) {
                throw RestEasyMessages.MESSAGES.youHaveNotSetABaseURIForTheClientProxy();
            }
            ClientRequest request = null;
            BaseClientResponse clientResponse = null;
            try {
                request = this.createRequest(exchange, args, headers);
                clientResponse = (BaseClientResponse)request.httpMethod(this._httpMethod);
            }
            catch (ClientResponseFailure crf) {
                clientResponse = (BaseClientResponse)crf.getResponse();
            }
            catch (Exception e) {
                ClientExceptionMapper mapper = this._providerFactory.getClientExceptionMapper(Exception.class);
                if (mapper != null) {
                    throw mapper.toException((Throwable)e);
                }
                throw new RuntimeException(e);
            }
            ClientErrorHandler errorHandler = new ClientErrorHandler(this._providerFactory.getClientErrorInterceptors());
            clientResponse.setAttributeExceptionsTo(this._method.toString());
            clientResponse.setAnnotations(this._method.getAnnotations());
            ClientRequestContext clientRequestContext = new ClientRequestContext(request, clientResponse, errorHandler, this._extractorFactory, this._baseUri);
            Object response = null;
            try {
                response = this._extractor.extractEntity(clientRequestContext, new Object[0]);
            }
            catch (RuntimeException e) {
                if (clientRequestContext.getClientResponse().getStatus() < 400) {
                    throw e;
                }
                response = e;
            }
            RESTEasyBindingData restResponse = new RESTEasyBindingData();
            if (response != null) {
                restResponse.setParameters(new Object[]{response});
            }
            restResponse.setHeaders((MultivaluedMap<String, String>)clientResponse.getHeaders());
            restResponse.setStatusCode(clientResponse.getStatus());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)"Incoming Headers to SwitchYard through OutboundHandler [");
                RESTEasyProxy.traceLog(LOGGER, (Map<String, List<String>>)clientResponse.getHeaders());
                LOGGER.trace((Object)"]");
            }
            RESTEasyBindingData rESTEasyBindingData = restResponse;
            return rESTEasyBindingData;
        }
        finally {
            if (!isProvidersSet) {
                ResteasyProviderFactory.popContextData(Providers.class);
            }
        }
    }

    private ClientRequest createRequest(Exchange exchange, Object[] args, MultivaluedMap<String, String> headers) {
        UriBuilder uriBuilder = this._defaultUriBuilder;
        String address = (String)exchange.getContext().getPropertyValue("org.switchyard.component.resteasy.address");
        if (address != null) {
            uriBuilder = this._subResourcePath != null ? UriBuilder.fromUri((String)String.format(ClientInvoker.createSubResourcePath(address, this._method), args)) : this.createUriBuilder(ClientInvoker.createUri(address), this._resourceClass, this._method);
        }
        if (this._subResourcePath != null) {
            uriBuilder = UriBuilder.fromUri((String)String.format(this._subResourcePath, args));
        }
        ClientRequest request = new ClientRequest(uriBuilder, this._executor, this._providerFactory);
        if (this._accepts != null) {
            request.header("Accept", (Object)RESTEasyUtil.mediaTypeToString(this._accepts));
        }
        for (Map.Entry entry : headers.entrySet()) {
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                request.header(name, (Object)value);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Outgoing Headers from SwitchYard through OutboundHandler [");
            RESTEasyProxy.traceLog(LOGGER, headers);
            LOGGER.trace((Object)"]");
        }
        this.copyClientInterceptorsTo((ClientInterceptorRepositoryImpl)request);
        boolean isClientResponseResult = ClientResponse.class.isAssignableFrom(this._method.getReturnType());
        request.followRedirects(!isClientResponseResult);
        for (int i = 0; i < this._marshallers.length; ++i) {
            this._marshallers[i].build(request, args[i]);
        }
        return request;
    }

    static {
        try {
            URIBUILDER_CLASS = Class.forName(AS7_URIBUILDER);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                URIBUILDER_CLASS = Class.forName(WFLY_URIBUILDER);
            }
            catch (ClassNotFoundException e) {
                RestEasyLogger.ROOT_LOGGER.unableToFindURIBuilder(e);
            }
        }
    }
}

