/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.SecurityServices;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.context.SecurityContextManager;
import org.switchyard.security.provider.SecurityProvider;

public class ProviderHandler
extends BaseHandler {
    private final SecurityProvider _securityProvider = SecurityServices.getSecurityProvider();
    private final SecurityContextManager _securityContextManager;

    public ProviderHandler(ServiceDomain serviceDomain) {
        this._securityContextManager = new SecurityContextManager(serviceDomain);
    }

    public void handleMessage(final Exchange exchange) throws HandlerException {
        final Service service = exchange.getProvider();
        ServiceSecurity serviceSecurity = service.getServiceMetadata().getSecurity();
        if (serviceSecurity != null) {
            SecurityContext securityContext = this._securityContextManager.getContext(exchange);
            PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    service.getProviderHandler().handleMessage(exchange);
                    return null;
                }
            };
            try {
                this._securityProvider.runAs(serviceSecurity, securityContext, (PrivilegedExceptionAction)action);
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                if (e instanceof HandlerException) {
                    throw (HandlerException)e;
                }
                throw new HandlerException((Throwable)e);
            }
        } else {
            service.getProviderHandler().handleMessage(exchange);
        }
    }
}

