/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.spi.ServiceRegistry;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private static Logger _logger = Logger.getLogger(DefaultServiceRegistry.class);
    private final Map<QName, List<Service>> _services = new HashMap<QName, List<Service>>();
    private ConcurrentHashMap<QName, ServiceReference> _references = new ConcurrentHashMap();

    @Override
    public synchronized List<Service> getServices() {
        LinkedList<Service> serviceList = new LinkedList<Service>();
        for (List<Service> services : this._services.values()) {
            serviceList.addAll(services);
        }
        return serviceList;
    }

    @Override
    public synchronized List<Service> getServices(QName serviceName) {
        if (!this._services.containsKey(serviceName)) {
            return Collections.emptyList();
        }
        return new LinkedList<Service>((Collection)this._services.get(serviceName));
    }

    @Override
    public synchronized Service registerService(Service service) {
        if (!this._services.containsKey(service.getName())) {
            this._services.put(service.getName(), new LinkedList());
        }
        this._services.get(service.getName()).add(service);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Registered Service '" + service.getName() + "'."));
        }
        return service;
    }

    @Override
    public synchronized void unregisterService(Service service) {
        List<Service> serviceList = this._services.get(service.getName());
        if (serviceList != null) {
            serviceList.remove(service);
            if (_logger.isDebugEnabled()) {
                QName serviceName = service.getName();
                String domainName = "";
                if (service.getDomain() != null && service.getDomain().getName() != null) {
                    domainName = service.getDomain().getName().toString();
                }
                _logger.debug((Object)("Unregistered Service '" + serviceName + "' from ServiceDomain '" + domainName + "'."));
            }
        }
    }

    @Override
    public void registerServiceReference(ServiceReference reference) {
        ServiceReference ref = this._references.putIfAbsent(reference.getName(), reference);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Registered ServiceReference '" + reference.getName() + "', " + "found previous map value of " + ref + "."));
        }
    }

    @Override
    public void unregisterServiceReference(ServiceReference reference) {
        ServiceReference removed = this._references.remove(reference.getName());
        if (removed != null && _logger.isDebugEnabled()) {
            _logger.debug((Object)("Unregistered ServiceReference '" + reference.getName() + "'."));
        }
    }

    @Override
    public List<ServiceReference> getServiceReferences() {
        if (this._references.isEmpty()) {
            return Collections.emptyList();
        }
        return new LinkedList<ServiceReference>(this._references.values());
    }

    @Override
    public ServiceReference getServiceReference(QName serviceName) {
        return this._references.get(serviceName);
    }
}

