/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence.config.ext;

import java.util.List;
import org.milyn.SmooksException;
import org.milyn.cdr.ConfigSearch;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.javabean.BeanInstancePopulator;
import org.w3c.dom.Element;

public class SetSelectorFromBeanPopulatorWiring
implements DOMVisitBefore {
    @ConfigParam
    private String selectorAttrName;

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext extensionContext = ExtensionContext.getExtensionContext(executionContext);
        SmooksResourceConfiguration config = extensionContext.getResourceStack().peek();
        if (config.getSelector() == null || config.getSelector().equals("none")) {
            Parameter beanIdParam = config.getParameter("beanId");
            String beanId = beanIdParam.getValue();
            SmooksResourceConfiguration beanCreatorConfig = this.findBeanCreatorConfig(beanId, extensionContext);
            if (beanCreatorConfig == null) {
                throw new SmooksConfigurationException("No <jb:wiring> configurations is found yet for beanId '" + beanId + "'. " + "This can mean that no <jb:wiring> is present that wires the bean with the bean id or that it is configured after the <" + element.getNodeName() + ">. " + "In this case you must set the selector in the '" + this.selectorAttrName + "' attribute.");
            }
            config.setSelector(beanCreatorConfig.getSelector());
        }
    }

    public SmooksResourceConfiguration findBeanCreatorConfig(String beanId, ExtensionContext extensionContext) {
        List<SmooksResourceConfiguration> creatorConfigs = extensionContext.lookupResource(new ConfigSearch().resource(BeanInstancePopulator.class.getName()).param("wireBeanId", beanId));
        if (creatorConfigs.size() > 1) {
            throw new SmooksConfigurationException("Multiple <jb:wiring> configurations exist for beanId '" + beanId + "'. " + "In this case you must set the selector in the '" + this.selectorAttrName + "' attribute because Smooks can't select a sensible default.");
        }
        if (creatorConfigs.size() == 1) {
            return creatorConfigs.get(0);
        }
        return null;
    }
}

