/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.deploy;

import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.jca.core.spi.rar.Activation;
import org.jboss.jca.core.spi.rar.MessageListener;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.switchyard.component.jca.JCAMessages;
import org.switchyard.component.jca.config.model.ActivationSpecModel;
import org.switchyard.component.jca.config.model.BatchCommitModel;
import org.switchyard.component.jca.config.model.ConnectionModel;
import org.switchyard.component.jca.config.model.ConnectionSpecModel;
import org.switchyard.component.jca.config.model.EndpointModel;
import org.switchyard.component.jca.config.model.InboundConnectionModel;
import org.switchyard.component.jca.config.model.InboundInteractionModel;
import org.switchyard.component.jca.config.model.InteractionSpecModel;
import org.switchyard.component.jca.config.model.JCABindingModel;
import org.switchyard.component.jca.config.model.ListenerModel;
import org.switchyard.component.jca.config.model.OutboundConnectionModel;
import org.switchyard.component.jca.config.model.OutboundInteractionModel;
import org.switchyard.component.jca.config.model.ProcessorModel;
import org.switchyard.component.jca.config.model.ResourceAdapterModel;
import org.switchyard.component.jca.deploy.InboundHandler;
import org.switchyard.component.jca.deploy.JCAInflowDeploymentMetaData;
import org.switchyard.component.jca.deploy.OutboundHandler;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;
import org.switchyard.component.jca.processor.AbstractOutboundProcessor;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;

public class JCAActivator
extends BaseActivator {
    private static final String JBOSS_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    static final String[] TYPES = new String[]{"jca"};
    private final ClassLoader _appClassLoader = Thread.currentThread().getContextClassLoader();
    private TransactionManager _transactionManager;
    private ResourceAdapterRepository _raRepository;

    public JCAActivator() {
        super(TYPES);
    }

    public ServiceHandler activateBinding(QName name, BindingModel config) {
        if (this._raRepository == null) {
            throw JCAMessages.MESSAGES.resourceAdapterRepositoryMustBeInjectedToActivateJCAComponent();
        }
        if (this._transactionManager == null) {
            try {
                this._transactionManager = (TransactionManager)new InitialContext().lookup(JBOSS_TRANSACTION_MANAGER);
            }
            catch (NamingException e) {
                throw JCAMessages.MESSAGES.unableToFindTransactionManagerInJNDIAt(JBOSS_TRANSACTION_MANAGER, e);
            }
        }
        if (config.isServiceBinding()) {
            return this.handleServiceBinding((JCABindingModel)config, name);
        }
        return this.handleReferenceBinding((JCABindingModel)config, name);
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    public void setResourceAdapterRepository(ResourceAdapterRepository repository) {
        this._raRepository = repository;
    }

    private InboundHandler handleServiceBinding(JCABindingModel config, QName name) {
        InboundInteractionModel inboundInteractionModel;
        JCABindingModel jcaconfig = config;
        InboundConnectionModel inboundConnectionModel = jcaconfig.getInboundConnection();
        if (inboundConnectionModel == null) {
            throw JCAMessages.MESSAGES.noInboundConnectionConfigured();
        }
        ResourceAdapterModel resourceAdapterModel = inboundConnectionModel.getResourceAdapter();
        if (resourceAdapterModel == null) {
            throw JCAMessages.MESSAGES.noResourceAdapterConfigured();
        }
        String raName = resourceAdapterModel.getName();
        if (raName == null) {
            throw JCAMessages.MESSAGES.noResourceAdapterNameConfigured();
        }
        String raid = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)raName);
        if (raid == null && raName.endsWith(".rar")) {
            raid = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)this.stripDotRarSuffix(raName));
        }
        if (raid == null) {
            throw JCAMessages.MESSAGES.uniqueKeyForResourceAdapter(raName);
        }
        Properties raProps = resourceAdapterModel.getProperties();
        Properties activationProps = null;
        ActivationSpecModel activationSpecModel = inboundConnectionModel.getActivationSpec();
        if (activationSpecModel != null) {
            activationProps = activationSpecModel.getProperties();
        }
        if ((inboundInteractionModel = jcaconfig.getInboundInteraction()) == null) {
            throw JCAMessages.MESSAGES.noInboundInteractionConfigured();
        }
        String listener = null;
        ListenerModel listenerModel = inboundInteractionModel.getListener();
        if (listenerModel != null) {
            listener = listenerModel.getClassName();
        }
        Class<?> listenerType = null;
        try {
            listenerType = this._appClassLoader.loadClass(listener != null ? listener : "javax.resource.cci.MessageListener");
        }
        catch (Exception e) {
            throw JCAMessages.MESSAGES.noListenerClassFound(listener, e);
        }
        EndpointModel endpointModel = inboundInteractionModel.getEndpoint();
        if (endpointModel == null) {
            throw JCAMessages.MESSAGES.noEndpointConfigured();
        }
        String endpointClassName = endpointModel.getEndpointClassName();
        Properties endpointProps = endpointModel.getProperties();
        ActivationSpec activationSpec = null;
        ResourceAdapter resourceAdapter = null;
        MessageListener listenerContainer = null;
        try {
            List listeners = this._raRepository.getMessageListeners(raid);
            for (MessageListener l : listeners) {
                if (!listenerType.equals(l.getType())) continue;
                listenerContainer = l;
            }
            if (listenerContainer == null) {
                throw JCAMessages.MESSAGES.listenerTypeIsNotSupportedByResourceAdapter(listenerType.getName(), raName);
            }
            Activation activation = listenerContainer.getActivation();
            activationSpec = activation.createInstance();
            if (activationProps != null && !activationProps.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)activationSpec, (Properties)activationProps);
            }
            resourceAdapter = this._raRepository.getResourceAdapter(raid);
            if (!raProps.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)resourceAdapter, (Properties)raProps);
            }
        }
        catch (Exception e) {
            throw JCAMessages.MESSAGES.couldnTAcquireTheResourceAdapter(raName, e);
        }
        AbstractInflowEndpoint endpoint = null;
        Class<?> endpointClass = null;
        try {
            endpointClass = this._appClassLoader.loadClass(endpointClassName);
            endpoint = (AbstractInflowEndpoint)endpointClass.newInstance();
            if (!endpointProps.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)endpoint, (Properties)endpointProps);
            }
        }
        catch (Exception e) {
            throw JCAMessages.MESSAGES.endpointClass(endpointClassName, e);
        }
        boolean transacted = inboundInteractionModel.isTransacted();
        endpoint.setApplicationClassLoader(this._appClassLoader).setServiceDomain(this.getServiceDomain()).setServiceQName(name).setDeliveryTransacted(transacted).setJCABindingModel(jcaconfig);
        JCAInflowDeploymentMetaData inflowMetaData = new JCAInflowDeploymentMetaData().setActivationSpec(activationSpec).setApplicationClassLoader(this._appClassLoader).setListenerInterface(listenerType).setMessageEndpoint(endpoint).setResourceAdapter(resourceAdapter).setTransactionManager(this._transactionManager).setDeliveryTransacted(transacted);
        BatchCommitModel batchCommit = inboundInteractionModel.getBatchCommit();
        if (transacted && batchCommit != null) {
            inflowMetaData.setUseBatchCommit(true);
            inflowMetaData.setBatchTimeout(batchCommit.getBatchTimeout());
            inflowMetaData.setBatchSize(batchCommit.getBatchSize());
        }
        return new InboundHandler(inflowMetaData, this.getServiceDomain());
    }

    private OutboundHandler handleReferenceBinding(JCABindingModel config, QName name) {
        InteractionSpecModel interactionSpecModel;
        OutboundInteractionModel outboundInteractionModel;
        Properties raProps;
        JCABindingModel jcaconfig = config;
        OutboundConnectionModel outboundConnectionModel = jcaconfig.getOutboundConnection();
        if (outboundConnectionModel == null) {
            throw JCAMessages.MESSAGES.noOutboundConnectionConfigured();
        }
        boolean managed = outboundConnectionModel.isManaged();
        if (!managed) {
            throw JCAMessages.MESSAGES.nonManagedScenarioIsNotSupportedYet();
        }
        ResourceAdapterModel resourceAdapterModel = outboundConnectionModel.getResourceAdapter();
        if (resourceAdapterModel != null && !(raProps = resourceAdapterModel.getProperties()).isEmpty()) {
            String raName = resourceAdapterModel.getName();
            String raid = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)this.stripDotRarSuffix(raName));
            if (raid == null) {
                throw JCAMessages.MESSAGES.uniqueKeyForResourceAdapter(raName);
            }
            ResourceAdapter resourceAdapter = null;
            try {
                resourceAdapter = this._raRepository.getResourceAdapter(raid);
                PropertyEditors.mapJavaBeanProperties((Object)resourceAdapter, (Properties)raProps);
            }
            catch (Exception e) {
                throw JCAMessages.MESSAGES.couldnTAcquireTheResourceAdapter(raName, e);
            }
        }
        if ((outboundInteractionModel = jcaconfig.getOutboundInteraction()) == null) {
            throw JCAMessages.MESSAGES.noOutboundInteractionConfigured();
        }
        ProcessorModel processorModel = outboundInteractionModel.getProcessor();
        if (processorModel == null) {
            throw JCAMessages.MESSAGES.noProcessorConfigured();
        }
        Properties processorProps = processorModel.getProperties();
        AbstractOutboundProcessor processor = null;
        String processorClassName = processorModel.getProcessorClassName();
        Class<?> processorClass = null;
        try {
            processorClass = this._appClassLoader.loadClass(processorClassName);
            processor = (AbstractOutboundProcessor)processorClass.newInstance();
            if (!processorProps.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)processor, (Properties)processorProps);
            }
        }
        catch (Exception e) {
            throw JCAMessages.MESSAGES.outboundProcessorClass(processorClassName, e);
        }
        ConnectionModel connectionModel = outboundConnectionModel.getConnection();
        if (connectionModel == null) {
            throw JCAMessages.MESSAGES.noConnectionConfigured();
        }
        String cfJndiName = connectionModel.getConnectionFactoryJNDIName();
        Properties connProps = connectionModel.getProperties();
        processor.setApplicationClassLoader(this._appClassLoader).setMCFProperties(connProps).setConnectionFactoryJNDIName(cfJndiName).setJCABindingModel(jcaconfig);
        ConnectionSpecModel connectionSpecModel = outboundInteractionModel.getConnectionSpec();
        if (connectionSpecModel != null) {
            String connSpecClassName = connectionSpecModel.getConnectionSpecClassName();
            Properties connSpecProps = connectionSpecModel.getProperties();
            processor.setConnectionSpec(connSpecClassName, connSpecProps);
        }
        if ((interactionSpecModel = outboundInteractionModel.getInteractionSpec()) != null) {
            String interactSpecClassName = interactionSpecModel.getInteractionSpecClassName();
            Properties interactSpecProps = interactionSpecModel.getProperties();
            processor.setInteractionSpec(interactSpecClassName, interactSpecProps);
        }
        return new OutboundHandler(processor, this.getServiceDomain());
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }
}

