/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.stl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.stl.UnaryFunction;
import org.apache.ode.utils.stl.UnaryFunctionEx;

public class CollectionsX {
    public static UnaryFunction<Map.Entry, Object> ufnMapEntry_getKey = new UnaryFunction<Map.Entry, Object>(){

        @Override
        public Object apply(Map.Entry x) {
            return x.getKey();
        }
    };
    public static UnaryFunction<Map.Entry, Object> ufnMapEntry_getValue = new UnaryFunction<Map.Entry, Object>(){

        @Override
        public Object apply(Map.Entry x) {
            return x.getValue();
        }
    };

    public static <T> void apply(Collection<T> coll, UnaryFunction<T, ?> f) {
        CollectionsX.apply(coll.iterator(), f);
    }

    public static <T> void apply(Iterator<T> i, UnaryFunction<T, ?> f) {
        while (i.hasNext()) {
            f.apply(i.next());
        }
    }

    public static <T> void apply(Collection<T> coll, UnaryFunctionEx<T, ?> f) throws Exception {
        CollectionsX.apply(coll.iterator(), f);
    }

    public static <T> void apply(Iterator<T> i, UnaryFunctionEx<T, ?> f) throws Exception {
        while (i.hasNext()) {
            f.apply(i.next());
        }
    }

    public static <T> T find_if(Collection<T> coll, MemberOfFunction<? super T> f) {
        return CollectionsX.find_if(coll.iterator(), f);
    }

    public static <T> T find_if(Iterator<T> i, MemberOfFunction<? super T> f) {
        while (i.hasNext()) {
            T x = i.next();
            if (!f.isMember(x)) continue;
            return x;
        }
        return null;
    }

    public static <T> Collection<T> insert(Collection<T> coll, Enumeration<? extends T> e) {
        while (e.hasMoreElements()) {
            coll.add(e.nextElement());
        }
        return coll;
    }

    public static <T> Collection<T> insert(Collection<T> coll, Iterator<? extends T> i) {
        while (i.hasNext()) {
            coll.add(i.next());
        }
        return coll;
    }

    public static <T> Collection<T> insert(Collection<T> coll, Collection<? extends T> src) {
        return CollectionsX.insert(coll, src.iterator());
    }

    public static <T> Collection<T> remove_if(Collection<T> coll, MemberOfFunction<T> f) {
        Iterator<T> i = coll.iterator();
        while (i.hasNext()) {
            if (!f.isMember(i.next())) continue;
            i.remove();
        }
        return coll;
    }

    public static <C extends Collection<T>, T, V extends T, E> C transform(C dest, Collection<E> src, UnaryFunction<E, V> f) {
        Iterator<E> i = src.iterator();
        while (i.hasNext()) {
            dest.add(f.apply(i.next()));
        }
        return dest;
    }

    public static <C extends Collection<T>, T, V extends T, E> C transformEx(C dest, Collection<E> src, UnaryFunctionEx<E, V> f) throws Exception {
        Iterator<E> i = src.iterator();
        while (i.hasNext()) {
            dest.add(f.apply(i.next()));
        }
        return dest;
    }

    public static <C extends Collection<T>, T, V extends T, E> C transform(C dest, Enumeration<E> i, UnaryFunction<E, V> f) {
        while (i.hasMoreElements()) {
            dest.add(f.apply(i.nextElement()));
        }
        return dest;
    }

    public static <C extends Collection<T>, T, S extends T> C filter(C dest, Collection<S> source, MemberOfFunction<S> function) {
        return CollectionsX.filter(dest, source.iterator(), function);
    }

    public static <C extends Collection<T>, T, S extends T> C filter(C dest, Iterator<S> source, MemberOfFunction<S> function) {
        while (source.hasNext()) {
            S next = source.next();
            if (!function.isMember(next)) continue;
            dest.add(next);
        }
        return dest;
    }

    public static <C extends Collection<T>, S, T extends S> C filter(C dest, Collection<S> src, Class<T> t) {
        return CollectionsX.filter(dest, src.iterator(), t);
    }

    public static <C extends Collection<T>, S, T extends S> C filter(C newList, Iterator<S> iterator, Class<T> t) {
        while (iterator.hasNext()) {
            S next = iterator.next();
            if (!t.isAssignableFrom(next.getClass())) continue;
            newList.add(next);
        }
        return newList;
    }

    public static <T> Collection<T> filter(Collection src, Class<T> aClass) {
        return CollectionsX.filter(new ArrayList(src.size()), src.iterator(), aClass);
    }
}

