/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http.util;

import java.util.regex.Pattern;

public final class HttpContentTypeUtil {
    private static Pattern[] textMimePatterns;

    private HttpContentTypeUtil() {
    }

    public static boolean isTextMimetype(String contentType) {
        if (contentType == null) {
            return false;
        }
        int separator = contentType.indexOf(59);
        if (separator >= 0) {
            contentType = contentType.substring(0, separator);
        }
        for (int i = 0; i < textMimePatterns.length; ++i) {
            if (!textMimePatterns[i].matcher(contentType).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        String[] textTypes = new String[]{"text/.*", "application/xml", "application/.*\\+xml"};
        textMimePatterns = new Pattern[textTypes.length];
        for (int i = 0; i < textMimePatterns.length; ++i) {
            HttpContentTypeUtil.textMimePatterns[i] = Pattern.compile(textTypes[i]);
        }
    }
}

