/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.milyn.assertion.AssertArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupWithPositionalQueryMethod {
    final Method method;
    final int queryIndex;
    final int parameterIndex;
    final ParameterType parameterType;

    public LookupWithPositionalQueryMethod(Method method, int queryIndex, int parameterIndex) {
        AssertArgument.isNotNull(method, "method");
        if (queryIndex < 0) {
            throw new IllegalArgumentException("queryIndex can't be smaller then zero");
        }
        if (queryIndex > 1) {
            throw new IllegalArgumentException("queryIndex can't be bigger then one");
        }
        if (parameterIndex < 0) {
            throw new IllegalArgumentException("queryIndex can't be smaller then zero");
        }
        if (parameterIndex > 1) {
            throw new IllegalArgumentException("queryIndex can't be bigger then one");
        }
        if (queryIndex == parameterIndex) {
            throw new IllegalArgumentException("queryIndex and parameterIndex can't be the same");
        }
        if (method.getParameterTypes()[parameterIndex].isAssignableFrom(List.class)) {
            this.parameterType = ParameterType.LIST;
        } else if (method.getParameterTypes()[parameterIndex].isAssignableFrom(Object[].class)) {
            this.parameterType = ParameterType.ARRAY;
        } else {
            throw new IllegalArgumentException("The parameter parameter isn't assigable with a List or Object Array");
        }
        this.method = method;
        this.queryIndex = queryIndex;
        this.parameterIndex = parameterIndex;
    }

    public Collection<?> invoke(Object obj, String query, Object[] parameters) {
        Object[] args = new Object[2];
        args[this.queryIndex] = query;
        args[this.parameterIndex] = this.parameterType == ParameterType.LIST ? Arrays.asList(parameters) : parameters;
        try {
            return (Collection)this.method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParameterType {
        ARRAY,
        LIST;

    }
}

