/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.mbean.internal;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.Transformer;
import org.switchyard.admin.Validator;
import org.switchyard.admin.mbean.ApplicationMXBean;
import org.switchyard.admin.mbean.internal.MBeans;

public class ManagedApplication
implements ApplicationMXBean {
    private Application _application;

    public ManagedApplication(Application application) {
        this._application = application;
    }

    @Override
    public List<String> getServices() {
        ArrayList<String> services = new ArrayList<String>();
        for (Service s : this._application.getServices()) {
            services.add(s.getName().toString());
        }
        return services;
    }

    @Override
    public List<String> getReferences() {
        ArrayList<String> references = new ArrayList<String>();
        for (Reference ref : this._application.getReferences()) {
            references.add(ref.getName().toString());
        }
        return references;
    }

    @Override
    public ObjectName getService(String serviceName) {
        Service service;
        ObjectName name = null;
        if (serviceName != null && (service = this._application.getService(QName.valueOf(serviceName))) != null) {
            name = MBeans.getObjectName(service);
        }
        return name;
    }

    @Override
    public ObjectName getReference(String referenceName) {
        Reference reference;
        ObjectName name = null;
        if (referenceName != null && (reference = this._application.getReference(QName.valueOf(referenceName))) != null) {
            name = MBeans.getObjectName(reference);
        }
        return name;
    }

    @Override
    public List<String> getComponentServices() {
        ArrayList<String> services = new ArrayList<String>();
        for (ComponentService cs : this._application.getComponentServices()) {
            services.add(cs.getName().toString());
        }
        return services;
    }

    @Override
    public ObjectName getComponentService(String componentServiceName) {
        ComponentService service;
        ObjectName name = null;
        if (componentServiceName != null && (service = this._application.getComponentService(QName.valueOf(componentServiceName))) != null) {
            name = MBeans.getObjectName(service);
        }
        return name;
    }

    @Override
    public List<ObjectName> getTransformers() {
        ArrayList<ObjectName> transformers = new ArrayList<ObjectName>();
        for (Transformer t : this._application.getTransformers()) {
            transformers.add(MBeans.getObjectName(t));
        }
        return transformers;
    }

    @Override
    public List<ObjectName> getValidators() {
        ArrayList<ObjectName> validators = new ArrayList<ObjectName>();
        for (Validator v : this._application.getValidators()) {
            validators.add(MBeans.getObjectName(v));
        }
        return validators;
    }

    @Override
    public String getName() {
        return this._application.getName().toString();
    }

    @Override
    public String getConfig() {
        return this._application.getConfig().toString();
    }
}

