/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import java.util.ArrayList;
import javax.resource.cci.MappedRecord;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.label.ComponentLabel;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.jca.composer.MappedRecordBindingData;

public class MappedRecordContextMapper
extends BaseRegexContextMapper<MappedRecordBindingData> {
    private static final String[] MAPPED_RECORD_LABELS = new String[]{ComponentLabel.JCA.label(), EndpointLabel.JCA.label()};

    public void mapFrom(MappedRecordBindingData source, Context context) throws Exception {
        String recordDescription;
        super.mapFrom((BindingData)source, context);
        MappedRecord record = source.getRecord();
        String recordName = record.getRecordName();
        if (recordName != null) {
            context.setProperty("recordName", (Object)recordName).addLabels(MAPPED_RECORD_LABELS);
        }
        if ((recordDescription = record.getRecordShortDescription()) != null) {
            context.setProperty("recordShortDescription", (Object)recordDescription).addLabels(MAPPED_RECORD_LABELS);
        }
        for (Object obj : record.keySet()) {
            String key;
            if (!(obj instanceof String) || !this.matches(key = (String)obj, this.getIncludeRegexes(), new ArrayList())) continue;
            context.setProperty(key, record.get((Object)key), Scope.EXCHANGE);
        }
    }

    public void mapTo(Context context, MappedRecordBindingData target) throws Exception {
        super.mapTo(context, (BindingData)target);
        MappedRecord record = target.getRecord();
        for (Property property : context.getProperties()) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null) continue;
            if (name.equals("recordName")) {
                record.setRecordName(value.toString());
                continue;
            }
            if (name.equals("recordShortDescription")) {
                record.setRecordShortDescription(value.toString());
                continue;
            }
            if (this.matches(name)) {
                record.put((Object)name, value);
                continue;
            }
            if (!this.matches(name, this.getIncludeRegexes(), new ArrayList())) continue;
            record.put((Object)name, value);
        }
    }
}

