/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.switchyard;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.camel.impl.DefaultMessage;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.camel.ContextPropertyUtil;
import org.switchyard.common.camel.HandlerDataSource;
import org.switchyard.common.camel.SwitchYardMessage;
import org.switchyard.label.BehaviorLabel;

public final class ExchangeMapper {
    public static final String CAMEL_PROPERTY_INCLUDES = "org.switchyard.includedCamelProperties";
    private static final String CAMEL_PROPERTY_PREFIX = "Camel";

    private ExchangeMapper() {
    }

    public static Message mapCamelToSwitchYard(org.apache.camel.Exchange camelExchange, Exchange syExchange, ExchangePhase phase) {
        Message message = syExchange.createMessage();
        org.apache.camel.Message camelMessage = ExchangeMapper.mapCamelPropertiesToSwitchYard(camelExchange, message.getContext(), phase);
        message.setContent(camelMessage.getBody());
        for (String attachmentName : camelMessage.getAttachmentNames()) {
            message.addAttachment(attachmentName, (DataSource)new HandlerDataSource(camelMessage.getAttachment(attachmentName)));
        }
        return message;
    }

    public static org.apache.camel.Message getCamelMessage(org.apache.camel.Exchange camelExchange, ExchangePhase phase) {
        if (phase.equals((Object)ExchangePhase.OUT) && camelExchange.hasOut()) {
            return camelExchange.getOut();
        }
        return camelExchange.getIn();
    }

    public static org.apache.camel.Message mapCamelPropertiesToSwitchYard(org.apache.camel.Exchange camelExchange, Context syContext, ExchangePhase phase) {
        for (String property : camelExchange.getProperties().keySet()) {
            if (ContextPropertyUtil.isReservedProperty((String)property, (Scope)Scope.EXCHANGE) || "org.switchyard.component.camel.implementation".equals(property)) continue;
            List propertyIncludes = (List)camelExchange.getProperty(CAMEL_PROPERTY_INCLUDES, List.class);
            if (property.startsWith(CAMEL_PROPERTY_PREFIX) && (propertyIncludes == null || !propertyIncludes.contains(property))) continue;
            syContext.setProperty(property, camelExchange.getProperty(property), Scope.EXCHANGE);
        }
        org.apache.camel.Message camelMessage = ExchangeMapper.getCamelMessage(camelExchange, phase);
        Set entrySet = camelMessage.getHeaders().entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            String header = (String)iter.next().getKey();
            if (ContextPropertyUtil.isReservedProperty((String)header, (Scope)Scope.MESSAGE)) continue;
            syContext.setProperty(header, camelMessage.getHeader(header), Scope.MESSAGE);
        }
        return camelMessage;
    }

    public static DefaultMessage mapSwitchYardToCamel(Exchange syExchange, org.apache.camel.Exchange camelExchange) {
        SwitchYardMessage camelMessage = new SwitchYardMessage();
        camelMessage.setBody(syExchange.getMessage().getContent());
        ExchangeMapper.mapSwitchYardPropertiesToCamel(syExchange.getContext(), camelExchange, (org.apache.camel.Message)camelMessage);
        for (String attachmentName : syExchange.getMessage().getAttachmentMap().keySet()) {
            camelMessage.addAttachment(attachmentName, new DataHandler(syExchange.getMessage().getAttachment(attachmentName)));
        }
        return camelMessage;
    }

    public static void mapSwitchYardPropertiesToCamel(Context syContext, org.apache.camel.Exchange camelExchange, org.apache.camel.Message camelMessage) {
        ExchangeMapper.mapSwitchYardPropertiesToCamel(syContext, camelExchange, camelMessage, false);
    }

    public static void mapSwitchYardPropertiesToCamel(Context syContext, org.apache.camel.Exchange camelExchange, org.apache.camel.Message camelMessage, boolean skipReserved) {
        for (Property property : syContext.getProperties()) {
            if (skipReserved) {
                if (ContextPropertyUtil.isReservedProperty((String)property.getName(), (Scope)Scope.EXCHANGE) || "org.switchyard.component.camel.implementation".equals(property.getName())) continue;
                List propertyIncludes = (List)camelExchange.getProperty(CAMEL_PROPERTY_INCLUDES, List.class);
                if (property.getName().startsWith(CAMEL_PROPERTY_PREFIX) && (propertyIncludes == null || !propertyIncludes.contains(property.getName()))) continue;
            }
            if (property.hasLabel(BehaviorLabel.TRANSIENT.label()) || ContextPropertyUtil.isReservedProperty((String)property.getName(), (Scope)property.getScope())) continue;
            if (Scope.EXCHANGE.equals((Object)property.getScope())) {
                camelExchange.setProperty(property.getName(), property.getValue());
                continue;
            }
            if (camelMessage == null) continue;
            camelMessage.setHeader(property.getName(), property.getValue());
        }
    }
}

