/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.switchyard;

import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.SwitchYardException;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.component.camel.switchyard.ExchangeMapper;
import org.switchyard.component.camel.switchyard.SwitchYardCamelComponentMessages;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.metadata.ServiceOperation;
import org.w3c.dom.Node;

public class SwitchYardConsumer
extends DefaultConsumer
implements ServiceHandler {
    private AtomicReference<Lifecycle.State> _state = new AtomicReference<Lifecycle.State>(Lifecycle.State.NONE);
    private QName _componentName;
    private String _namespace;
    public static final String IMPLEMENTATION_ROUTE = "org.switchyard.component.camel.implementation";
    public static final String COMPONENT_NAME = "org.switchyard.component.camel.componentName";

    public SwitchYardConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleMessage(Exchange switchyardExchange) throws HandlerException {
        org.apache.camel.Exchange camelExchange = this.getEndpoint().createExchange(this.isInOut(switchyardExchange) ? org.apache.camel.ExchangePattern.InOut : org.apache.camel.ExchangePattern.InOnly);
        DefaultMessage targetMessage = ExchangeMapper.mapSwitchYardToCamel(switchyardExchange, camelExchange);
        camelExchange.setProperty(IMPLEMENTATION_ROUTE, (Object)true);
        camelExchange.setProperty(COMPONENT_NAME, (Object)this._componentName);
        camelExchange.setProperty("org.switchyard.component.camel.namespace", (Object)this._namespace);
        ServiceOperation operation = switchyardExchange.getContract().getProviderOperation();
        camelExchange.setProperty("org.switchyard.operationName", (Object)operation.getName());
        camelExchange.setProperty("org.switchyard.faultType", (Object)operation.getFaultType());
        camelExchange.setProperty("org.switchyard.serviceName", (Object)switchyardExchange.getProvider().getName());
        camelExchange.setIn((org.apache.camel.Message)targetMessage);
        this.invokeCamelProcessor(camelExchange);
        if (camelExchange.isFailed()) {
            Message switchyardMessage = this.isInOut(switchyardExchange) ? switchyardExchange.createMessage() : null;
            org.apache.camel.Message camelMessage = ExchangeMapper.mapCamelPropertiesToSwitchYard(camelExchange, switchyardMessage != null ? switchyardMessage.getContext() : switchyardExchange.getContext(), ExchangePhase.OUT);
            QName faultName = switchyardExchange.getContract().getProviderOperation().getFaultType();
            Class declaredFault = faultName != null && QNameUtil.isJavaMessageType((QName)faultName) ? QNameUtil.toJavaMessageType((QName)faultName) : null;
            Object camelFault = camelExchange.getException();
            if (camelFault == null) {
                if (camelExchange.hasOut() && camelExchange.getOut().isFault()) {
                    camelFault = camelExchange.getOut().getBody();
                } else if (camelExchange.getIn().isFault()) {
                    camelFault = camelExchange.getIn().getBody();
                }
            }
            if (camelFault != null && declaredFault != null && declaredFault.isAssignableFrom(camelFault.getClass())) {
                switchyardMessage.setContent(camelFault);
                switchyardExchange.sendFault(switchyardMessage);
                return;
            }
            if (camelFault instanceof Throwable) {
                throw new HandlerException((Throwable)Throwable.class.cast(camelFault));
            }
            if (camelFault instanceof Node && this.isInOut(switchyardExchange)) {
                switchyardMessage.setContent((Object)((Node)camelFault));
                switchyardExchange.sendFault(switchyardMessage);
                return;
            }
            if (camelFault != null) {
                camelMessage.setBody(camelFault);
            }
            String faultMessage = (String)camelMessage.getBody(String.class);
            throw SwitchYardCamelComponentMessages.MESSAGES.camelExchangeFailedWithoutException(faultMessage);
        }
        if (this.isInOut(switchyardExchange)) {
            this.sendResponse(camelExchange, switchyardExchange);
            return;
        }
        ExchangeMapper.mapCamelPropertiesToSwitchYard(camelExchange, switchyardExchange.getContext(), ExchangePhase.OUT);
    }

    public synchronized void start() {
        if (this.getState() == Lifecycle.State.STARTED) {
            return;
        }
        if (this.getState() != Lifecycle.State.NONE) {
            throw SwitchYardCamelComponentMessages.MESSAGES.invalidHandlerState();
        }
        this.setState(Lifecycle.State.STARTING);
        try {
            super.start();
            this.setState(Lifecycle.State.STARTED);
        }
        catch (Exception ex) {
            this.setState(Lifecycle.State.NONE);
            throw new SwitchYardException((Throwable)ex);
        }
    }

    public synchronized void stop() {
        if (this.getState() == Lifecycle.State.NONE) {
            return;
        }
        if (this.getState() != Lifecycle.State.STARTED) {
            throw SwitchYardCamelComponentMessages.MESSAGES.invalidHandlerState();
        }
        this.setState(Lifecycle.State.STOPPING);
        try {
            super.stop();
            this.setState(Lifecycle.State.NONE);
        }
        catch (Exception ex) {
            this.setState(Lifecycle.State.STARTED);
            throw new SwitchYardException((Throwable)ex);
        }
    }

    public void setComponentName(QName componentName) {
        this._componentName = componentName;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    private void invokeCamelProcessor(org.apache.camel.Exchange camelExchange) throws HandlerException {
        try {
            this.getProcessor().process(camelExchange);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private void sendResponse(org.apache.camel.Exchange camelExchange, Exchange switchyardExchange) throws HandlerException {
        Message message = ExchangeMapper.mapCamelToSwitchYard(camelExchange, switchyardExchange, ExchangePhase.OUT);
        switchyardExchange.send(message);
    }

    private boolean isInOut(Exchange exchange) {
        return exchange.getContract().getProviderOperation().getExchangePattern() == ExchangePattern.IN_OUT;
    }

    public void handleFault(Exchange exchange) {
    }

    public Lifecycle.State getState() {
        return this._state.get();
    }

    private void setState(Lifecycle.State newState) {
        if (newState == null) {
            throw SwitchYardCamelComponentMessages.MESSAGES.stateCannotBeNull();
        }
        this._state.set(newState);
    }
}

