/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.factory;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.container.ApplicationContext;
import org.milyn.javabean.BeanPopulator;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.factory.Alias;
import org.milyn.javabean.factory.Factory;
import org.milyn.javabean.factory.IllegalFactoryAliasException;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FactoryDefinitionParser {
    public Factory<?> parse(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FactoryDefinitionParserFactory {
        private static Log logger = LogFactory.getLog(FactoryDefinitionParserFactory.class);
        public static final String DEFAULT_ALIAS = "default";
        private static volatile ConcurrentMap<String, FactoryDefinitionParser> instances = new ConcurrentHashMap<String, FactoryDefinitionParser>();
        private static volatile Map<String, Class<? extends FactoryDefinitionParser>> aliasToClassMap;

        public static FactoryDefinitionParser getInstance(String alias, ApplicationContext applicationContext) {
            String className;
            if (StringUtils.isEmpty((String)alias) || alias.equals(DEFAULT_ALIAS)) {
                className = applicationContext.getStore().getGlobalParams().getStringParameter(BeanPopulator.GLOBAL_DEFAULT_FACTORY_DEFINITION_PARSER_CLASS, BeanPopulator.DEFAULT_FACTORY_DEFINITION_PARSER_CLASS);
            } else {
                FactoryDefinitionParserFactory.loadAliasToClassMap();
                Class clazz = aliasToClassMap.get(alias);
                if (clazz == null) {
                    try {
                        clazz = ClassUtil.forName(alias, FactoryDefinitionParser.class);
                        className = clazz.getName();
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalFactoryAliasException("The FactoryDefinitionParser alias '" + alias + "' can't be found and doesn't seem to be a classname.", e);
                    }
                }
                className = clazz.getName();
            }
            FactoryDefinitionParser factoryDefinitionParser = (FactoryDefinitionParser)instances.get(className);
            if (factoryDefinitionParser == null) {
                try {
                    Class factoryDefinitionParserClass = ClassUtil.forName(className, FactoryDefinitionParser.class);
                    FactoryDefinitionParser newFactoryDefinitionParser = (FactoryDefinitionParser)factoryDefinitionParserClass.newInstance();
                    instances.putIfAbsent(className, newFactoryDefinitionParser);
                    factoryDefinitionParser = (FactoryDefinitionParser)instances.get(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("The FactoryDefinitionParser class '" + className + "' can't be found", e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("The FactoryDefinitionParser class '" + className + "'can't be instantiated. The FactoryDefinitionParser class must have a argumentless public constructor.", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("The FactoryDefinitionParser class '" + className + "' can't be instantiated.", e);
                }
            }
            return factoryDefinitionParser;
        }

        public static FactoryDefinitionParser getInstance(ApplicationContext applicationContext) {
            return FactoryDefinitionParserFactory.getInstance(DEFAULT_ALIAS, applicationContext);
        }

        public static Map<String, Class<? extends FactoryDefinitionParser>> getAliasToClassMap() {
            FactoryDefinitionParserFactory.loadAliasToClassMap();
            return Collections.unmodifiableMap(aliasToClassMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static synchronized void loadAliasToClassMap() throws DataDecodeException {
            if (aliasToClassMap != null) return;
            Class<FactoryDefinitionParserFactory> clazz = FactoryDefinitionParserFactory.class;
            synchronized (FactoryDefinitionParserFactory.class) {
                if (aliasToClassMap != null) return;
                List<Class<FactoryDefinitionParser>> factories = ClassUtil.getClasses("META-INF/smooks-javabean-factory-definition-parsers.inf", FactoryDefinitionParser.class);
                HashSet<String> toRemove = new HashSet<String>();
                aliasToClassMap = new HashMap<String, Class<? extends FactoryDefinitionParser>>();
                for (Class<FactoryDefinitionParser> factory : factories) {
                    String[] names;
                    Alias alias = factory.getAnnotation(Alias.class);
                    if (alias == null) continue;
                    for (String name : names = alias.value()) {
                        if (name.equals(DEFAULT_ALIAS)) {
                            throw new IllegalFactoryAliasException("The alias 'default' is a reserved alias name. Please use a different name");
                        }
                        if (aliasToClassMap.containsKey(name)) {
                            Class<? extends FactoryDefinitionParser> prevClass = aliasToClassMap.get(name);
                            logger.warn((Object)("More than one FactoryDefinitionParser has the alias '" + name + "' on the classpath. Previous: '" + prevClass.getName() + "'. Current '" + factory.getName() + "'. To use one of these factories you will have to declare the complete class name as alias."));
                            toRemove.add(name);
                        }
                        aliasToClassMap.put(name, factory);
                    }
                }
                for (String name : toRemove) {
                    aliasToClassMap.remove(name);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }
}

