/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;
import org.switchyard.as7.extension.SwitchYardDeploymentMarker;
import org.switchyard.as7.extension.deployment.SwitchYardMetaData;

public class SwitchYardConfigDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String SWITCHYARD_XML = "META-INF/switchyard.xml";
    private static final String SWITCHYARD_XML_WAR = "WEB-INF/switchyard.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        VirtualFile warSwitchYardXml;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile switchyardXml = DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) ? ((warSwitchYardXml = deploymentRoot.getRoot().getChild(SWITCHYARD_XML_WAR)).exists() ? warSwitchYardXml : deploymentRoot.getRoot().getChild(SWITCHYARD_XML)) : deploymentRoot.getRoot().getChild(SWITCHYARD_XML);
        if (!switchyardXml.exists()) {
            return;
        }
        String archiveName = deploymentUnit.getName();
        SwitchYardMetaData switchYardMetaData = new SwitchYardMetaData(archiveName, this.stripArchiveSuffix(archiveName));
        switchYardMetaData.setSwitchYardFile(switchyardXml);
        deploymentUnit.putAttachment(SwitchYardMetaData.ATTACHMENT_KEY, (Object)switchYardMetaData);
        SwitchYardDeploymentMarker.mark(deploymentUnit);
    }

    private String stripArchiveSuffix(String archiveName) {
        for (ARCHIVE_SUFFIX s : ARCHIVE_SUFFIX.values()) {
            if (!archiveName.toUpperCase().endsWith("." + s.toString())) continue;
            return archiveName.substring(0, archiveName.lastIndexOf("."));
        }
        return archiveName;
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static enum ARCHIVE_SUFFIX {
        JAR,
        WAR,
        ESB;

    }
}

