/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.jaxb.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.namespace.QName;
import org.switchyard.Message;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.Scannable;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.internal.TransformMessages;
import org.switchyard.transform.jaxb.internal.JAXBTransformerFactory;

@Scannable(value=false)
public class JAXBMarshalTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private JAXBContext _jaxbContext;
    private boolean _isAttachmentEnabled;
    private boolean _isXOPPackage;
    private String _contextPath;

    public JAXBMarshalTransformer(QName from, QName to, String contextPath, boolean isAttachmentEnabled, boolean isXOPPackage) throws SwitchYardException {
        super(from, to);
        this._isAttachmentEnabled = isAttachmentEnabled;
        this._isXOPPackage = isXOPPackage;
        this._contextPath = contextPath;
        this._jaxbContext = JAXBTransformerFactory.getContext(from, contextPath);
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Message transform(Message message) {
        Marshaller marshaller;
        try {
            marshaller = this._jaxbContext.createMarshaller();
            if (this._isAttachmentEnabled) {
                marshaller.setAttachmentMarshaller((AttachmentMarshaller)new JAXBAttachmentMarshaller(message, this._isXOPPackage));
            }
        }
        catch (JAXBException e) {
            throw TransformMessages.MESSAGES.failedToCreateMarshaller(this.getFrom().toString(), e);
        }
        try {
            StringWriter resultWriter = new StringWriter();
            Object javaObject = message.getContent();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            try {
                marshaller.marshal(javaObject, (Writer)resultWriter);
                message.setContent((Object)resultWriter.toString());
            }
            catch (MarshalException ife) {
                resultWriter = new StringWriter();
                Class objectFactory = JAXBMarshalTransformer.getObjectFactory(javaObject.getClass());
                Method[] methods = objectFactory.getMethods();
                Method method = null;
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] parameterTypes = methods[i].getParameterTypes();
                    if (parameterTypes.length != 1 || parameterTypes[0] != javaObject.getClass()) continue;
                    method = methods[i];
                }
                JAXBElement jaxbElement = null;
                try {
                    Object of = objectFactory.newInstance();
                    jaxbElement = (JAXBElement)method.invoke(of, javaObject);
                }
                catch (IllegalAccessException iae) {
                    throw TransformMessages.MESSAGES.failedToMarshalForType(this.getFrom().toString(), iae);
                }
                catch (InvocationTargetException ite) {
                    throw TransformMessages.MESSAGES.failedToMarshalForType(this.getFrom().toString(), ite);
                }
                catch (InstantiationException e) {
                    throw TransformMessages.MESSAGES.failedToMarshalForType(this.getFrom().toString(), e);
                }
                marshaller.marshal((Object)jaxbElement, (Writer)resultWriter);
                message.setContent((Object)resultWriter.toString());
            }
        }
        catch (JAXBException e) {
            throw TransformMessages.MESSAGES.failedToMarshallForType(this.getFrom().toString(), e);
        }
        return message;
    }

    private static Class getObjectFactory(Class<?> type) {
        if (type.getAnnotation(XmlType.class) != null) {
            String objectFactoryName = type.getPackage().getName() + "." + "ObjectFactory";
            return Classes.forName((String)objectFactoryName, JAXBTransformerFactory.class);
        }
        return null;
    }

    class JAXBAttachmentMarshaller
    extends AttachmentMarshaller {
        private Message _message;
        private boolean _xop;

        public JAXBAttachmentMarshaller(Message message, boolean isXOPPackage) {
            this._message = message;
            this._xop = isXOPPackage;
        }

        public String addMtomAttachment(DataHandler data, String elementNamespace, String elementLocalName) {
            String cid = "cid:" + elementLocalName + "." + UUID.randomUUID() + "@switchyard.jboss.org";
            this._message.addAttachment(cid, data.getDataSource());
            return cid;
        }

        public String addMtomAttachment(final byte[] data, final int offset, final int length, String mimeType, String elementNamespace, String elementLocalName) {
            final String cid = "cid:" + elementLocalName + "." + UUID.randomUUID() + "@switchyard.jboss.org";
            DataSource ds = new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(data, offset, length);
                }

                public OutputStream getOutputStream() throws IOException {
                    throw new UnsupportedOperationException("OutputStream is not supported");
                }

                public String getContentType() {
                    return "application/octet-stream";
                }

                public String getName() {
                    return cid;
                }
            };
            this._message.addAttachment(cid, ds);
            return cid;
        }

        public String addSwaRefAttachment(DataHandler data) {
            String cid = "cid:" + data.getName() + "." + UUID.randomUUID() + "@switchyard.jboss.org";
            this._message.addAttachment(cid, data.getDataSource());
            return cid;
        }

        public boolean isXOPPackage() {
            return this._xop;
        }
    }
}

