/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OVarType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OMessageVarType
extends OVarType {
    private static final long serialVersionUID = 256680050844726425L;
    public QName messageType;
    public final Map<String, Part> parts = new LinkedHashMap<String, Part>();
    public final OElementVarType docLitType;

    public OMessageVarType(OProcess owner, QName messageType, Collection<Part> parts) {
        super(owner);
        this.messageType = messageType;
        for (Part part : parts) {
            this.parts.put(part.name, part);
        }
        this.docLitType = parts.size() == 1 && parts.iterator().next().type instanceof OElementVarType ? (OElementVarType)parts.iterator().next().type : null;
    }

    boolean isDocLit() {
        return this.docLitType != null;
    }

    @Override
    public Node newInstance(Document doc) {
        Element el = doc.createElementNS(null, "message");
        for (Part part : this.parts.values()) {
            Element partElement = doc.createElementNS(null, part.name);
            partElement.appendChild(part.type.newInstance(doc));
            el.appendChild(partElement);
        }
        return el;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('(');
        buf.append(this.messageType.toString());
        buf.append(')');
        return buf.toString();
    }

    public static class Part
    extends OBase {
        private static final long serialVersionUID = -2356665271228433779L;
        public String name;
        public OVarType type;

        public Part(OProcess owner, String partName, OVarType partType) {
            super(owner);
            this.name = partName;
            this.type = partType;
        }
    }
}

