/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate;

import java.lang.reflect.ParameterizedType;
import javax.xml.namespace.QName;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.validate.ValidationResult;
import org.switchyard.validate.Validator;

public abstract class BaseValidator<T>
implements Validator<T> {
    private QName _name;

    public BaseValidator() {
        this._name = JavaTypes.toMessageType(this.getType());
    }

    public BaseValidator(QName name) {
        this._name = name;
    }

    @Override
    public Validator<T> setName(QName name) {
        this._name = name;
        return this;
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public Class<T> getType() {
        try {
            ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
            return (Class)pt.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    public static ValidationResult validResult() {
        return new DefaultValidationResult(true, null);
    }

    public static ValidationResult invalidResult(String error) {
        return new DefaultValidationResult(false, error);
    }

    public static ValidationResult invalidResult() {
        return BaseValidator.invalidResult(null);
    }

    protected static QName toMessageType(Class<?> type) {
        return JavaTypes.toMessageType(type);
    }

    protected static class DefaultValidationResult
    implements ValidationResult {
        private boolean _valid;
        private String _detail;

        public DefaultValidationResult(boolean valid, String detail) {
            this._valid = valid;
            this._detail = detail;
        }

        @Override
        public boolean isValid() {
            return this._valid;
        }

        @Override
        public String getDetail() {
            return this._detail;
        }
    }
}

