/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.format;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.switchyard.common.io.CountingOutputStream;
import org.switchyard.common.type.Classes;
import org.switchyard.serial.BaseSerializer;
import org.switchyard.serial.FormatType;

public final class XMLBeanSerializer
extends BaseSerializer {
    public XMLBeanSerializer() {
        super(FormatType.XML_BEAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int serialize(T obj, Class<T> type, OutputStream out) throws IOException {
        out = new CountingOutputStream((OutputStream)new BufferedOutputStream(out, this.getBufferSize()));
        EL el = new EL();
        XMLEncoder enc = new XMLEncoder(out);
        try {
            enc.setExceptionListener(el);
            enc.writeObject(obj);
            enc.flush();
        }
        finally {
            if (this.isCloseEnabled()) {
                enc.close();
            }
        }
        IOException ioe = el.getIOException();
        if (ioe != null) {
            throw ioe;
        }
        return ((CountingOutputStream)out).getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(InputStream in, Class<T> type) throws IOException {
        Object obj;
        in = new BufferedInputStream(in, this.getBufferSize());
        EL el = new EL();
        XMLDecoder dec = new XMLDecoder(in, null, (ExceptionListener)el, Classes.getTCCL());
        try {
            obj = dec.readObject();
        }
        finally {
            if (this.isCloseEnabled()) {
                dec.close();
            }
        }
        IOException ioe = el.getIOException();
        if (ioe != null) {
            throw ioe;
        }
        return type.cast(obj);
    }

    private static final class EL
    implements ExceptionListener {
        private Exception _e;

        private EL() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            if (this._e != null) {
                this._e = e;
            }
        }

        public IOException getIOException() {
            if (this._e != null) {
                if (this._e instanceof IOException) {
                    return (IOException)this._e;
                }
                return new IOException(this._e);
            }
            return null;
        }
    }
}

