/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.converter.DelegatingXMLStreamReader;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.StreamSourceCache;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedCxfPayload<T>
extends CxfPayload<T>
implements StreamCache {
    private static final Logger LOG = LoggerFactory.getLogger(CachedCxfPayload.class);

    public CachedCxfPayload(CxfPayload<T> orig, Exchange exchange, XmlConverter xml) {
        super(orig.getHeaders(), new ArrayList<Source>(orig.getBodySources()), orig.getNsMap());
        ListIterator<Source> li = this.getBodySources().listIterator();
        while (li.hasNext()) {
            DOMSource document;
            Source source = li.next();
            XMLStreamReader reader = null;
            if (source instanceof StaxSource) {
                reader = ((StaxSource)source).getXMLStreamReader();
            } else if (source instanceof StAXSource) {
                reader = ((StAXSource)source).getXMLStreamReader();
            }
            if (reader != null) {
                Map<String, String> nsmap = this.getNsMap();
                if (nsmap != null && !(reader instanceof DelegatingXMLStreamReader)) {
                    reader = new DelegatingXMLStreamReader(reader, nsmap);
                }
                CachedOutputStream cos = new CachedOutputStream(exchange);
                try {
                    StaxUtils.copy((XMLStreamReader)reader, (OutputStream)cos);
                    li.set((Source)new StreamSourceCache(cos.newStreamCache()));
                    continue;
                }
                catch (Exception e) {
                    StreamResult sr = new StreamResult((OutputStream)cos);
                    try {
                        xml.toResult(source, (Result)sr);
                        li.set((Source)new StreamSourceCache(cos.newStreamCache()));
                        continue;
                    }
                    catch (Exception e2) {
                        LOG.debug("Error during parsing XMLStreamReader from StaxSource/StAXSource. Will fallback to using DOM mode. This exception is ignored", (Throwable)e2);
                    }
                }
            }
            if ((document = (DOMSource)exchange.getContext().getTypeConverter().tryConvertTo(DOMSource.class, exchange, (Object)source)) == null) continue;
            li.set(document);
        }
    }

    private CachedCxfPayload(CachedCxfPayload<T> orig, Exchange exchange) throws IOException {
        super(orig.getHeaders(), new ArrayList<Source>(orig.getBodySources()), orig.getNsMap());
        ListIterator<Source> li = this.getBodySources().listIterator();
        while (li.hasNext()) {
            Source source = li.next();
            if (!(source instanceof StreamCache)) continue;
            li.set((Source)((StreamCache)source).copy(exchange));
        }
    }

    public void reset() {
        for (Source source : this.getBodySources()) {
            if (!(source instanceof StreamCache)) continue;
            ((StreamCache)source).reset();
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this.getBodySources().size() == 0) {
            return;
        }
        Source body = this.getBodySources().get(0);
        if (body instanceof StreamCache) {
            ((StreamCache)body).writeTo(os);
        } else {
            try {
                StaxUtils.copy((Source)body, (OutputStream)os);
            }
            catch (XMLStreamException e) {
                throw new IOException("Transformation failed", e);
            }
        }
    }

    public boolean inMemory() {
        boolean inMemory = true;
        for (Source source : this.getBodySources()) {
            if (!(source instanceof StreamCache) || ((StreamCache)source).inMemory()) continue;
            inMemory = false;
        }
        return inMemory;
    }

    public long length() {
        return 0L;
    }

    public StreamCache copy(Exchange exchange) throws IOException {
        return new CachedCxfPayload<T>(this, exchange);
    }
}

