/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.io.PrintStream;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;

public class TimedTraceListener
implements TraceListener {
    PrintStream out = System.err;

    public void setOutputStream(PrintStream stream) {
        this.out = stream;
    }

    public void open() {
        this.out.println("<trace time=\"" + System.currentTimeMillis() + "\">");
    }

    public void close() {
        this.out.println("<end time=\"" + System.currentTimeMillis() + "\"/></trace>");
    }

    public void enter(InstructionInfo instruction, XPathContext context) {
        int loc = instruction.getConstructType();
        if (loc == 149 || loc == 181) {
            String file;
            String tag = "<";
            tag = tag + (loc == 149 ? "function" : "template");
            String name = null;
            if (instruction.getObjectName() != null) {
                name = instruction.getObjectName().getDisplayName();
            } else if (instruction.getProperty("name") != null) {
                name = instruction.getProperty("name").toString();
            }
            if (name != null) {
                tag = tag + " name=\"" + name + "\"";
            }
            if (instruction.getProperty("match") != null) {
                tag = tag + " match=\"" + instruction.getProperty("match") + "\"";
            }
            if ((file = instruction.getSystemId()) != null) {
                if (file.length() > 15) {
                    file = "*" + file.substring(file.length() - 14);
                }
                tag = tag + " file=\"" + file + "\"";
            }
            tag = tag + " line=\"" + instruction.getLineNumber() + "\"";
            tag = tag + " time=\"" + System.currentTimeMillis() + "\"";
            tag = tag + ">";
            this.out.println(tag);
        }
    }

    public void leave(InstructionInfo instruction) {
        int loc = instruction.getConstructType();
        if (loc == 149 || loc == 181) {
            String tag = "<end time=\"" + System.currentTimeMillis() + "\"/></";
            tag = tag + (loc == 149 ? "function>" : "template>");
            this.out.println(tag);
        }
    }

    public void startCurrentItem(Item item) {
    }

    public void endCurrentItem(Item item) {
    }
}

