/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.jboss.logging.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.soap.Feature;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.SOAPLogger;
import org.switchyard.component.soap.SOAPMessages;
import org.switchyard.component.soap.WebServiceConsumeException;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.composer.SOAPComposition;
import org.switchyard.component.soap.composer.SOAPFaultInfo;
import org.switchyard.component.soap.composer.SOAPMessageComposer;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.EndpointPublisherFactory;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.label.BehaviorLabel;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private static final String NO_RESPONSE = "No response returned.";
    private final SOAPBindingModel _config;
    private final String _bindingName;
    private final String _referenceName;
    private MessageComposer<SOAPBindingData> _messageComposer;
    private Dispatch<SOAPMessage> _dispatcher;
    private Port _wsdlPort;
    private String _bindingId;
    private Boolean _documentStyle;
    private Feature _feature = new Feature();

    public OutboundHandler(SOAPBindingModel config) {
        this._config = config;
        this._bindingName = config.getName();
        this._referenceName = config.getReference().getName();
    }

    protected void doStart() throws WebServiceConsumeException {
        if (this._dispatcher == null) {
            try {
                HTTPClientPolicy httpClientPolicy;
                Definition definition = WSDLUtil.readWSDL(this._config.getWsdl());
                WSDLUtil.filterWSDL(definition, this._config.getModelConfiguration().getPropertyResolver());
                PortName portName = this._config.getPort();
                javax.wsdl.Service wsdlService = WSDLUtil.getService(definition, portName);
                this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
                portName.setServiceQName(wsdlService.getQName());
                portName.setName(this._wsdlPort.getName());
                String style = WSDLUtil.getStyle(this._wsdlPort);
                this._documentStyle = style.equals("document");
                this._feature = WSDLUtil.getFeature(definition, this._wsdlPort, this._documentStyle);
                MTOMFeature mtom = this._feature.getMtom(this._config);
                this._bindingId = WSDLUtil.getBindingId(this._wsdlPort, mtom.isEnabled());
                this._messageComposer = SOAPComposition.getMessageComposer(this._config);
                ((SOAPMessageComposer)this._messageComposer).setDocumentStyle(this._documentStyle);
                ((SOAPMessageComposer)this._messageComposer).setWsdlPort(this._wsdlPort);
                ((SOAPMessageComposer)this._messageComposer).setMtomEnabled(mtom.isEnabled());
                if (this._config.getMtomConfig() != null) {
                    ((SOAPMessageComposer)this._messageComposer).setXopExpand(this._config.getMtomConfig().isXopExpand());
                }
                URL wsdlUrl = WSDLUtil.getURL(this._config.getWsdl());
                SOAPLogger.ROOT_LOGGER.creatingDispatchWithWSDL(wsdlUrl.toString());
                Service service = Service.create((URL)wsdlUrl, (QName)portName.getServiceQName());
                this._dispatcher = service.createDispatch(portName.getPortQName(), SOAPMessage.class, Service.Mode.MESSAGE, new WebServiceFeature[]{this._feature.getAddressing(), mtom});
                Client client = ((DispatchImpl)this._dispatcher).getClient();
                client.setThreadLocalRequestContext(true);
                if (this._feature.isAddressingEnabled().booleanValue()) {
                    Interceptor<? extends org.apache.cxf.message.Message> addressingInterceptor = EndpointPublisherFactory.getEndpointPublisher().createAddressingInterceptor();
                    client.getOutInterceptors().add(addressingInterceptor);
                    client.getOutFaultInterceptors().add(addressingInterceptor);
                } else {
                    this._dispatcher.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
                }
                if (this._config.getEndpointAddress() != null) {
                    this._dispatcher.getRequestContext().put("javax.xml.ws.service.endpoint.address", this._config.getEndpointAddress());
                }
                Integer timeout = this._config.getTimeout();
                HTTPConduit conduit = (HTTPConduit)client.getConduit();
                if (this._config.getProxyConfig() != null) {
                    httpClientPolicy = new HTTPClientPolicy();
                    httpClientPolicy.setProxyServerType(ProxyServerType.fromValue((String)this._config.getProxyConfig().getType()));
                    httpClientPolicy.setProxyServer(this._config.getProxyConfig().getHost());
                    if (this._config.getProxyConfig().getPort() != null) {
                        httpClientPolicy.setProxyServerPort(Integer.valueOf(this._config.getProxyConfig().getPort()).intValue());
                    }
                    conduit.setClient(httpClientPolicy);
                    if (this._config.getProxyConfig().getUser() != null) {
                        ProxyAuthorizationPolicy policy = new ProxyAuthorizationPolicy();
                        policy.setUserName(this._config.getProxyConfig().getUser());
                        policy.setPassword(this._config.getProxyConfig().getPassword());
                        conduit.setProxyAuthorization(policy);
                    }
                }
                if (this._config.hasAuthentication().booleanValue()) {
                    AuthorizationPolicy policy = new AuthorizationPolicy();
                    if (this._config.isBasicAuth().booleanValue()) {
                        policy.setUserName(this._config.getBasicAuthConfig().getUser());
                        policy.setPassword(this._config.getBasicAuthConfig().getPassword());
                        policy.setAuthorizationType("Basic");
                    } else {
                        policy.setUserName(this._config.getNtlmAuthConfig().getDomain() + "\\" + this._config.getNtlmAuthConfig().getUser());
                        policy.setPassword(this._config.getNtlmAuthConfig().getPassword());
                        HTTPClientPolicy httpClientPolicy2 = new HTTPClientPolicy();
                        if (timeout != null) {
                            httpClientPolicy2.setConnectionTimeout((long)timeout.intValue());
                        } else {
                            httpClientPolicy2.setConnectionTimeout(36000L);
                        }
                        httpClientPolicy2.setAllowChunking(false);
                        conduit.setClient(httpClientPolicy2);
                    }
                    conduit.setAuthorization(policy);
                }
                if (timeout != null) {
                    if (conduit.getClient() != null) {
                        conduit.getClient().setConnectionTimeout((long)timeout.intValue());
                        conduit.getClient().setReceiveTimeout((long)timeout.intValue());
                    } else {
                        httpClientPolicy = new HTTPClientPolicy();
                        httpClientPolicy.setConnectionTimeout((long)timeout.intValue());
                        httpClientPolicy.setReceiveTimeout((long)timeout.intValue());
                        conduit.setClient(httpClientPolicy);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new WebServiceConsumeException(e);
            }
            catch (WSDLException wsdle) {
                throw new WebServiceConsumeException(wsdle);
            }
        }
    }

    public void stop() {
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        block17: {
            exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._bindingName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            try {
                Message message;
                SOAPBindingData request;
                if (this.getState() != Lifecycle.State.STARTED) {
                    throw SOAPMessages.MESSAGES.referenceBindingNotStarted(this._referenceName, this._bindingName);
                }
                if (SOAPUtil.getFactory(this._bindingId) == null) {
                    throw SOAPMessages.MESSAGES.failedToInstantiateSOAPMessageFactory();
                }
                Boolean oneWay = false;
                String action = null;
                try {
                    request = (SOAPBindingData)this._messageComposer.decompose(exchange, (BindingData)new SOAPBindingData(SOAPUtil.createMessage(this._bindingId)));
                    QName firstBodyElement = SOAPUtil.getFirstBodyElement(request.getSOAPMessage());
                    action = WSDLUtil.getSoapAction(this._wsdlPort, firstBodyElement, this._documentStyle);
                    oneWay = WSDLUtil.isOneWay(this._wsdlPort, firstBodyElement, this._documentStyle);
                    if (this._feature.isAddressingEnabled().booleanValue()) {
                        Context context = exchange.getContext();
                        this._dispatcher.getRequestContext().put("SWITCHYARD_CONTEXT", context);
                        String toAddress = SOAPUtil.getToAddress(exchange.getContext());
                        if (toAddress != null) {
                            this._dispatcher.getRequestContext().put("javax.xml.ws.service.endpoint.address", toAddress);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                    throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Outbound ---> Request:[" + this._referenceName + "][" + SOAPUtil.soapMessageToString(request.getSOAPMessage()) + "]" + (oneWay != false ? " oneWay " : "")));
                }
                SOAPMessage response = this.invokeService(request, oneWay, action);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Outbound <--- Response:[" + this._referenceName + "][" + SOAPUtil.soapMessageToString(response) + "]"));
                }
                if (response == null) break block17;
                Boolean hasFault = response.getSOAPBody().hasFault();
                try {
                    Map httpHeaders;
                    Integer status;
                    SOAPBindingData bindingData = new SOAPBindingData(response);
                    if (hasFault.booleanValue()) {
                        SOAPFaultInfo faultInfo = new SOAPFaultInfo();
                        faultInfo.copyFaultInfo(response);
                        bindingData.setSOAPFaultInfo(faultInfo);
                    }
                    if ((status = (Integer)this._dispatcher.getResponseContext().get("javax.xml.ws.http.response.code")) != null) {
                        bindingData.setStatus(status);
                    }
                    if ((httpHeaders = (Map)this._dispatcher.getResponseContext().get("javax.xml.ws.http.response.headers")) != null) {
                        bindingData.setHttpHeaders(httpHeaders);
                    }
                    message = this._messageComposer.compose((BindingData)bindingData, exchange);
                }
                catch (Exception e) {
                    throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
                }
                if (hasFault.booleanValue()) {
                    exchange.sendFault(message);
                } else {
                    exchange.send(message);
                }
            }
            catch (SOAPException se) {
                LOGGER.error((Object)se);
                throw SOAPMessages.MESSAGES.unexpectedExceptionHandlingSOAPMessage(se);
            }
        }
    }

    private SOAPMessage invokeService(SOAPBindingData bindingData, Boolean oneWay, String action) throws SOAPException {
        SOAPMessage soapMessage = bindingData.getSOAPMessage();
        SOAPMessage response = null;
        try {
            HashMap<String, List<String>> httpHeaders = (HashMap<String, List<String>>)this._dispatcher.getRequestContext().get("javax.xml.ws.http.request.headers");
            if (httpHeaders == null) {
                httpHeaders = new HashMap<String, List<String>>();
                this._dispatcher.getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
            }
            httpHeaders.putAll(bindingData.getHttpHeaders());
            if (!this._feature.isAddressingEnabled().booleanValue() && action != null) {
                HashMap reqHeaders = CastUtils.cast((Map)((Map)this._dispatcher.getRequestContext().get(org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
                if (reqHeaders.containsKey("SOAPAction")) {
                    HashMap copy = new HashMap();
                    for (Map.Entry entry : reqHeaders.entrySet()) {
                        copy.put(entry.getKey(), entry.getValue());
                    }
                    copy.remove("SOAPAction");
                    reqHeaders = copy;
                }
                this._dispatcher.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", "\"" + action + "\"");
            }
            if (oneWay.booleanValue()) {
                this._dispatcher.invokeOneWay((Object)soapMessage);
            } else {
                response = (SOAPMessage)this._dispatcher.invoke((Object)soapMessage);
            }
        }
        catch (SOAPFaultException sfex) {
            response = SOAPUtil.generateFault(sfex, this._bindingId);
        }
        catch (WebServiceException wsex) {
            if (wsex.getMessage().equals(NO_RESPONSE) && this._feature.isAddressingEnabled().booleanValue()) {
                SOAPLogger.ROOT_LOGGER.sentAMessageWithReplyToToARequestResponseWebserviceSoNoResponseReturned();
            }
            throw new SOAPException((Throwable)wsex);
        }
        catch (Exception ex) {
            throw SOAPMessages.MESSAGES.cannotProcessSOAPRequest(ex);
        }
        return response;
    }
}

