/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.SwitchYardException;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.runtime.RuntimeLogger;
import org.switchyard.runtime.RuntimeMessages;
import org.switchyard.validate.ValidationFailureException;
import org.switchyard.validate.ValidationResult;
import org.switchyard.validate.Validator;
import org.switchyard.validate.ValidatorRegistry;

public class ValidateHandler
extends BaseHandler {
    private static final String KEY_VALIDATED_TYPE = "org.switchyard.validatedType";
    private static Logger _logger = Logger.getLogger(ValidateHandler.class);
    private ValidatorRegistry _registry;

    public ValidateHandler(ValidatorRegistry registry) {
        this._registry = registry;
    }

    public void handleMessage(Exchange exchange) throws ValidationFailureException {
        Validator<?> validator = this.get(exchange);
        if (validator != null) {
            try {
                ValidationResult result = this.applyValidator(exchange, validator);
                if (!result.isValid()) {
                    String msg = RuntimeMessages.MESSAGES.validatorFailed(validator.getClass().getName(), validator.getType().getName(), validator.getName().toString(), result.getDetail());
                    throw new ValidationFailureException(validator, result, msg);
                }
            }
            catch (SwitchYardException e) {
                String msg = RuntimeMessages.MESSAGES.validatorFailed(validator.getClass().getName(), validator.getType().getName(), validator.getName().toString(), e);
                throw new ValidationFailureException(validator, e.getCause() != null ? e.getCause() : e, msg);
            }
        }
    }

    public void handleFault(Exchange exchange) {
        ValidationResult result;
        Validator<?> validator = this.get(exchange);
        if (validator != null && !(result = this.applyValidator(exchange, validator)).isValid()) {
            RuntimeLogger.ROOT_LOGGER.validatorFailed(validator.getClass().getName(), result.getDetail());
        }
    }

    private Validator<?> get(Exchange exchange) {
        Property contentType = exchange.getContext().getProperty("org.switchyard.contentType");
        Property validatedType = exchange.getContext().getProperty(KEY_VALIDATED_TYPE);
        if (contentType != null) {
            if (validatedType != null && contentType.getValue().equals(validatedType.getValue())) {
                return null;
            }
            return this._registry.getValidator((QName)contentType.getValue());
        }
        return null;
    }

    private ValidationResult applyValidator(Exchange exchange, Validator validator) {
        Message message = exchange.getMessage();
        ValidationResult validationResult = null;
        validationResult = Message.class.isAssignableFrom(validator.getType()) ? validator.validate((Object)message) : validator.validate(message.getContent(validator.getType()));
        if (validationResult.isValid() && _logger.isDebugEnabled()) {
            _logger.debug((Object)("Validated Message (" + System.identityHashCode(message) + ") with name '" + validator.getName() + "' using validator type '" + validator.getType() + "'."));
        }
        exchange.getContext().setProperty(KEY_VALIDATED_TYPE, (Object)validator.getType()).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        return validationResult;
    }
}

