/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.composer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceContext;
import org.switchyard.component.common.composer.SecurityBindingData;
import org.switchyard.component.soap.SOAPLogger;
import org.switchyard.component.soap.composer.SOAPFaultInfo;
import org.switchyard.security.SecurityServices;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.extractor.SOAPMessageCredentialExtractor;
import org.switchyard.security.credential.extractor.ServletRequestCredentialExtractor;
import org.switchyard.security.credential.extractor.WebServiceContextCredentialExtractor;

public class SOAPBindingData
implements SecurityBindingData {
    private final SOAPMessage _soapMessage;
    private final WebServiceContext _webServiceContext;
    private SOAPFaultInfo _soapFaultInfo;
    private Integer _status;
    private Map<String, List<String>> _httpHeaders = new HashMap<String, List<String>>();
    private static ServletRequestCredentialExtractor srce = null;

    public SOAPBindingData(SOAPMessage soapMessage) {
        this(soapMessage, null);
    }

    public SOAPBindingData(SOAPMessage soapMessage, WebServiceContext webServiceContext) {
        this._soapMessage = soapMessage;
        this._webServiceContext = webServiceContext;
        if (srce == null) {
            srce = SecurityServices.getServletRequestCredentialExtractor();
        }
    }

    public SOAPMessage getSOAPMessage() {
        return this._soapMessage;
    }

    public SOAPFaultInfo getSOAPFaultInfo() {
        return this._soapFaultInfo;
    }

    public void setSOAPFaultInfo(SOAPFaultInfo faultInfo) {
        this._soapFaultInfo = faultInfo;
    }

    public WebServiceContext getWebServiceContext() {
        return this._webServiceContext;
    }

    public Integer getStatus() {
        return this._status;
    }

    public void setStatus(Integer status) {
        this._status = status;
    }

    public Map<String, List<String>> getHttpHeaders() {
        return this._httpHeaders;
    }

    public void setHttpHeaders(Map<String, List<String>> httpHeaders) {
        this._httpHeaders = httpHeaders;
    }

    public Set<Credential> extractCredentials() {
        HashSet<Credential> credentials = new HashSet<Credential>();
        credentials.addAll(new SOAPMessageCredentialExtractor().extract(this.getSOAPMessage()));
        credentials.addAll(new WebServiceContextCredentialExtractor().extract(this.getWebServiceContext()));
        try {
            credentials.addAll(srce.extract((Object)this.getServletRequest()));
        }
        catch (UnsupportedOperationException uoe) {
            SOAPLogger.ROOT_LOGGER.credentialsAreIgnoredForServletRequest();
        }
        return credentials;
    }

    private ServletRequest getServletRequest() {
        if (this._webServiceContext != null) {
            return (ServletRequest)this._webServiceContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        }
        return null;
    }
}

