/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.spi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.format.SERObjectSerializer;
import org.switchyard.serial.format.XMLBeanSerializer;
import org.switchyard.serial.spi.SerializationProvider;

public class JDKSerializationProvider
extends SerializationProvider {
    private static final Map<FormatType, Class<? extends Serializer>> MAP;

    @Override
    public Set<FormatType> getSupportedFormats() {
        return MAP.keySet();
    }

    @Override
    public Serializer newSerializer(FormatType format) {
        Class<? extends Serializer> c = MAP.get((Object)format);
        return c != null ? (Serializer)Construction.construct(c) : null;
    }

    static {
        LinkedHashMap<FormatType, Class> map = new LinkedHashMap<FormatType, Class>();
        map.put(FormatType.SER_OBJECT, SERObjectSerializer.class);
        map.put(FormatType.XML_BEAN, XMLBeanSerializer.class);
        MAP = Collections.unmodifiableMap(map);
    }
}

