/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.config.model.v2;

import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.transform.config.model.v1.V1TransformMarshaller;
import org.switchyard.transform.config.model.v2.V2CamelTransformModel;
import org.switchyard.transform.config.model.v2.V2DozerFileEntryModel;
import org.switchyard.transform.config.model.v2.V2DozerMappingFilesModel;
import org.switchyard.transform.config.model.v2.V2DozerTransformModel;
import org.switchyard.transform.config.model.v2.V2JAXBTransformModel;

public class V2TransformMarshaller
extends V1TransformMarshaller {
    private static final String TRANSFORM_DOZER = "transform.dozer";
    private static final String TRANSFORM_CAMEL = "transform.camel";
    private static final String TRANSFORM_JAXB = "transform.jaxb";

    public V2TransformMarshaller(Descriptor desc) {
        super(desc);
    }

    @Override
    public Model read(Configuration config) {
        String name = config.getName();
        Descriptor desc = this.getDescriptor();
        if (name.equals(TRANSFORM_DOZER)) {
            return new V2DozerTransformModel(config, desc);
        }
        if (name.equals("mappingFiles")) {
            return new V2DozerMappingFilesModel(config, desc);
        }
        if (name.equals("entry")) {
            return new V2DozerFileEntryModel(config, desc);
        }
        if (name.equals(TRANSFORM_CAMEL)) {
            return new V2CamelTransformModel(config, desc);
        }
        if (name.equals(TRANSFORM_JAXB)) {
            return new V2JAXBTransformModel(config, desc);
        }
        return super.read(config);
    }
}

