/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Suspendable;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.ipfilter.IpV4Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUDPNettyServerBootstrapFactory
extends ServiceSupport
implements NettyServerBootstrapFactory,
Suspendable {
    protected static final Logger LOG = LoggerFactory.getLogger(SingleUDPNettyServerBootstrapFactory.class);
    private static final String LOOPBACK_INTERFACE = "lo";
    private static final String MULTICAST_SUBNET = "224.0.0.0/4";
    private ChannelGroup allChannels;
    private CamelContext camelContext;
    private ThreadFactory threadFactory;
    private NettyServerBootstrapConfiguration configuration;
    private ChannelPipelineFactory pipelineFactory;
    private DatagramChannelFactory datagramChannelFactory;
    private ConnectionlessBootstrap connectionlessBootstrap;
    private NetworkInterface multicastNetworkInterface;
    private DatagramChannel datagramChannel;
    private Channel channel;
    private WorkerPool workerPool;

    @Override
    public void init(CamelContext camelContext, NettyServerBootstrapConfiguration configuration, ChannelPipelineFactory pipelineFactory) {
        this.camelContext = camelContext;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
        this.allChannels = configuration.getChannelGroup() != null ? configuration.getChannelGroup() : new DefaultChannelGroup(SingleUDPNettyServerBootstrapFactory.class.getName());
    }

    @Override
    public void init(ThreadFactory threadFactory, NettyServerBootstrapConfiguration configuration, ChannelPipelineFactory pipelineFactory) {
        this.threadFactory = threadFactory;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
        this.allChannels = configuration.getChannelGroup() != null ? configuration.getChannelGroup() : new DefaultChannelGroup(SingleUDPNettyServerBootstrapFactory.class.getName());
    }

    @Override
    public void addChannel(Channel channel) {
        this.allChannels.add((Object)channel);
    }

    @Override
    public void removeChannel(Channel channel) {
        this.allChannels.remove((Object)channel);
    }

    @Override
    public void addConsumer(NettyConsumer consumer) {
    }

    @Override
    public void removeConsumer(NettyConsumer consumer) {
    }

    protected void doStart() throws Exception {
        if (this.camelContext == null && this.threadFactory == null) {
            throw new IllegalArgumentException("Either CamelContext or ThreadFactory must be set on " + this);
        }
        this.startServerBootstrap();
    }

    protected void doStop() throws Exception {
        this.stopServerBootstrap();
    }

    protected void doResume() throws Exception {
    }

    protected void doSuspend() throws Exception {
    }

    protected void startServerBootstrap() throws Exception {
        int count = this.configuration.getWorkerCount() > 0 ? this.configuration.getWorkerCount() : NettyHelper.DEFAULT_IO_THREADS;
        this.workerPool = new NioDatagramWorkerPool((Executor)Executors.newCachedThreadPool(), count);
        this.datagramChannelFactory = new NioDatagramChannelFactory(this.workerPool);
        this.connectionlessBootstrap = new ConnectionlessBootstrap((ChannelFactory)this.datagramChannelFactory);
        this.connectionlessBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
        this.connectionlessBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
        this.connectionlessBootstrap.setOption("reuseAddress", (Object)this.configuration.isReuseAddress());
        this.connectionlessBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
        this.connectionlessBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        this.connectionlessBootstrap.setOption("child.broadcast", (Object)this.configuration.isBroadcast());
        this.connectionlessBootstrap.setOption("sendBufferSize", (Object)this.configuration.getSendBufferSize());
        this.connectionlessBootstrap.setOption("receiveBufferSize", (Object)this.configuration.getReceiveBufferSize());
        if (this.configuration.getReceiveBufferSizePredictor() > 0) {
            this.connectionlessBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(this.configuration.getReceiveBufferSizePredictor()));
        }
        if (this.configuration.getBacklog() > 0) {
            this.connectionlessBootstrap.setOption("backlog", (Object)this.configuration.getBacklog());
        }
        if (this.configuration.getOptions() != null) {
            for (Map.Entry<String, Object> entry : this.configuration.getOptions().entrySet()) {
                this.connectionlessBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
        LOG.debug("Created ConnectionlessBootstrap {} with options: {}", (Object)this.connectionlessBootstrap, (Object)this.connectionlessBootstrap.getOptions());
        this.connectionlessBootstrap.setPipelineFactory(this.pipelineFactory);
        InetSocketAddress hostAddress = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        IpV4Subnet multicastSubnet = new IpV4Subnet(MULTICAST_SUBNET);
        if (multicastSubnet.contains(this.configuration.getHost())) {
            this.datagramChannel = (DatagramChannel)this.connectionlessBootstrap.bind((SocketAddress)new InetSocketAddress(this.configuration.getPort()));
            String networkInterface = this.configuration.getNetworkInterface() == null ? LOOPBACK_INTERFACE : this.configuration.getNetworkInterface();
            this.multicastNetworkInterface = NetworkInterface.getByName(networkInterface);
            ObjectHelper.notNull((Object)this.multicastNetworkInterface, (String)("No network interface found for '" + networkInterface + "'."));
            LOG.info("ConnectionlessBootstrap joining {}:{} using network interface: {}", new Object[]{this.configuration.getHost(), this.configuration.getPort(), this.multicastNetworkInterface.getName()});
            this.datagramChannel.joinGroup(hostAddress, this.multicastNetworkInterface).syncUninterruptibly();
            this.allChannels.add((Object)this.datagramChannel);
        } else {
            LOG.info("ConnectionlessBootstrap binding to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            this.channel = this.connectionlessBootstrap.bind((SocketAddress)hostAddress);
            this.allChannels.add((Object)this.channel);
        }
    }

    protected void stopServerBootstrap() {
        LOG.info("ConnectionlessBootstrap disconnecting from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        LOG.trace("Closing {} channels", (Object)this.allChannels.size());
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        if (this.datagramChannelFactory != null) {
            this.datagramChannelFactory.releaseExternalResources();
            this.datagramChannelFactory = null;
        }
        if (this.workerPool != null) {
            this.workerPool.shutdown();
            this.workerPool = null;
        }
    }
}

