/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.logging.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.bean.BeanLogger;
import org.switchyard.component.bean.BeanMessages;
import org.switchyard.component.bean.BeanServiceMetadata;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.Invocation;
import org.switchyard.component.bean.Property;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.internal.ReferenceInvokerBean;
import org.switchyard.component.bean.internal.context.ContextProxy;
import org.switchyard.component.bean.internal.exchange.ExchangeProxy;
import org.switchyard.component.bean.internal.message.MessageProxy;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.ComponentNames;
import org.switchyard.deploy.ServiceHandler;

public class ServiceProxyHandler
extends BaseServiceHandler
implements ServiceHandler {
    private static Logger _logger = Logger.getLogger(ServiceProxyHandler.class);
    private String _serviceName;
    private Object _serviceBean;
    private BeanServiceMetadata _serviceMetadata;
    private BeanDeploymentMetaData _beanDeploymentMetaData;
    private CreationalContext<?> _beanCreationalContext;
    private Map<String, Map<String, ServiceReference>> _references = new HashMap<String, Map<String, ServiceReference>>();

    public ServiceProxyHandler(String serviceName, Object serviceBean, BeanServiceMetadata serviceMetadata, BeanDeploymentMetaData beanDeploymentMetaData, CreationalContext<?> creationalContext) {
        this._serviceName = serviceName;
        this._serviceBean = serviceBean;
        this._serviceMetadata = serviceMetadata;
        this._beanDeploymentMetaData = beanDeploymentMetaData;
        this._beanCreationalContext = creationalContext;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        this.handle(exchange);
    }

    public void handleFault(Exchange exchange) {
    }

    public void addReference(ServiceReference reference) {
        String unqualifiedName = ComponentNames.unqualify((ServiceReference)reference).getLocalPart();
        Map<String, ServiceReference> refs = this._references.get(unqualifiedName);
        if (refs == null) {
            refs = new HashMap<String, ServiceReference>();
            this._references.put(unqualifiedName, refs);
        }
        refs.put(reference.getName().getLocalPart(), reference);
    }

    public void injectImplementationProperties(PropertyResolver resolver) {
        for (Field field : this._serviceBean.getClass().getDeclaredFields()) {
            Object property;
            Property propAnno = field.getAnnotation(Property.class);
            if (propAnno == null) continue;
            String propertyName = propAnno.name();
            if (propertyName.equals("")) {
                propertyName = field.getName();
            }
            if ((property = resolver.resolveProperty(propertyName)) == null) continue;
            if (field.getType().isAssignableFrom(property.getClass())) {
                new FieldAccess(field).write(this._serviceBean, property);
                continue;
            }
            BeanLogger.ROOT_LOGGER.propertyHasIncompatibleTypeBean(propAnno.name(), this._serviceMetadata.getServiceClass().getName(), field.getType().getName(), property.getClass().getName());
        }
    }

    protected ClassLoader getDeploymentClassLoader() {
        return this._beanDeploymentMetaData.getDeploymentClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handle(Exchange exchange) throws HandlerException {
        Invocation invocation = this._serviceMetadata.getInvocation(exchange);
        if (invocation == null) throw BeanMessages.MESSAGES.unexpectedErrorBeanServiceMetadataShouldReturnAnInvocationInstanceOrThrowABeanComponentException();
        ExchangePattern exchangePattern = exchange.getContract().getProviderOperation().getExchangePattern();
        try {
            Object responseObject;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("CDI Bean Service ExchangeHandler proxy class received " + exchangePattern + " Exchange (" + System.identityHashCode(exchange) + ") for Bean Service '" + exchange.getProvider().getName() + "'.  Invoking bean method '" + invocation.getMethod().getName() + "'."));
            }
            Context origContext = ContextProxy.setContext(exchange.getContext());
            Message origMessage = MessageProxy.setMessage(exchange.getMessage());
            Exchange origExchange = ExchangeProxy.setExchange(exchange);
            try {
                responseObject = invocation.getMethod().invoke(this._serviceBean, invocation.getArgs());
            }
            finally {
                ContextProxy.setContext(origContext);
                MessageProxy.setMessage(origMessage);
                ExchangeProxy.setExchange(origExchange);
            }
            if (exchangePattern != ExchangePattern.IN_OUT || exchange.getPhase() == ExchangePhase.OUT) return;
            Message message = exchange.createMessage();
            message.setContent(responseObject);
            exchange.send(message);
            return;
        }
        catch (Exception ex) {
            Throwable faultContent;
            String errMsg = BeanMessages.MESSAGES.invocationOfOperationFailed(invocation.getMethod().getName(), this._serviceBean.getClass().getName());
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)errMsg, (Throwable)ex);
            }
            if ((faultContent = ex) instanceof InvocationTargetException) {
                faultContent = ((InvocationTargetException)ex).getTargetException();
            }
            if (exchangePattern != ExchangePattern.IN_OUT) throw new HandlerException(faultContent);
            for (Class<?> expectedFault : invocation.getMethod().getExceptionTypes()) {
                if (!expectedFault.isAssignableFrom(faultContent.getClass())) continue;
                exchange.sendFault(exchange.createMessage().setContent((Object)faultContent));
                return;
            }
            throw new HandlerException(faultContent);
        }
    }

    protected void doStart() {
        ServiceReference target;
        Map<String, ServiceReference> refs;
        Map<String, ServiceReference> refs2;
        String unqualifiedName;
        String qualifiedName;
        for (ClientProxyBean proxyBean : this._beanDeploymentMetaData.getClientProxies()) {
            if (proxyBean.getServiceName().contains("/")) {
                qualifiedName = proxyBean.getServiceName();
                unqualifiedName = proxyBean.getServiceName().split("/")[1];
                if (!this._references.containsKey(unqualifiedName) || !(refs2 = this._references.get(unqualifiedName)).containsKey(qualifiedName)) continue;
                proxyBean.setService(refs2.get(qualifiedName));
                continue;
            }
            if (!this._references.containsKey(proxyBean.getServiceName())) continue;
            refs = this._references.get(proxyBean.getServiceName());
            target = refs.values().iterator().next();
            proxyBean.setService(target);
            if (refs.size() <= 1) continue;
            BeanLogger.ROOT_LOGGER.ambiguousReferenceInjection(proxyBean.getServiceName(), target.getName().getLocalPart());
        }
        for (ReferenceInvokerBean invokerBean : this._beanDeploymentMetaData.getReferenceInvokers()) {
            if (invokerBean.getServiceName().contains("/")) {
                qualifiedName = invokerBean.getServiceName();
                unqualifiedName = invokerBean.getServiceName().split("/")[1];
                if (!this._references.containsKey(unqualifiedName) || !(refs2 = this._references.get(unqualifiedName)).containsKey(qualifiedName)) continue;
                invokerBean.setReference(refs2.get(qualifiedName));
                continue;
            }
            if (!this._references.containsKey(invokerBean.getServiceName())) continue;
            refs = this._references.get(invokerBean.getServiceName());
            target = refs.values().iterator().next();
            invokerBean.setReference(target);
            if (refs.size() <= 1) continue;
            BeanLogger.ROOT_LOGGER.ambiguousReferenceInjection(invokerBean.getServiceName(), target.getName().getLocalPart());
        }
    }

    protected void doStop() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("STOP: " + this._serviceName));
        }
        this._beanCreationalContext.release();
    }
}

