/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.observers;

import java.lang.annotation.Annotation;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.BeanInstancePopulator;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.lifecycle.BeanContextLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanContextLifecycleObserver;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.repository.BeanId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanWiringObserver
implements BeanContextLifecycleObserver {
    private BeanId watchedBeanId;
    private Class<?> watchedBeanType;
    private Class<? extends Annotation> watchedBeanAnnotation;
    private BeanId watchingBeanId;
    private BeanInstancePopulator populator;

    public BeanWiringObserver(BeanId watchingBean, BeanInstancePopulator populator) {
        this.watchingBeanId = watchingBean;
        this.populator = populator;
    }

    public BeanWiringObserver watchedBeanId(BeanId watchedBeanId) {
        this.watchedBeanId = watchedBeanId;
        return this;
    }

    public BeanWiringObserver watchedBeanType(Class watchedBeanType) {
        this.watchedBeanType = watchedBeanType;
        return this;
    }

    public BeanWiringObserver watchedBeanAnnotation(Class<? extends Annotation> watchedBeanAnnotation) {
        this.watchedBeanAnnotation = watchedBeanAnnotation;
        return this;
    }

    @Override
    public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
        BeanId beanId = event.getBeanId();
        BeanLifecycle lifecycle = event.getLifecycle();
        if (lifecycle == BeanLifecycle.ADD) {
            if (this.watchedBeanId != null && beanId != this.watchedBeanId) {
                return;
            }
            Object bean = event.getBean();
            if (!BeanWiringObserver.isMatchingBean(bean, this.watchedBeanType, this.watchedBeanAnnotation)) {
                return;
            }
            ExecutionContext executionContext = event.getExecutionContext();
            this.populator.populateAndSetPropertyValue(bean, executionContext.getBeanContext(), this.watchingBeanId, executionContext, event.getSource());
        } else if (beanId == this.watchingBeanId && lifecycle == BeanLifecycle.REMOVE) {
            BeanContext beanContext = event.getExecutionContext().getBeanContext();
            beanContext.removeObserver(this);
            if (this.watchedBeanId != null) {
                beanContext.removeBean(this.watchedBeanId, event.getSource());
            }
        }
    }

    public static boolean isMatchingBean(Object bean, Class<?> type, Class<? extends Annotation> annotation) {
        Class<?> beanClass = bean.getClass();
        if (type != null && !type.isAssignableFrom(beanClass)) {
            return false;
        }
        return annotation == null || beanClass.isAnnotationPresent(annotation);
    }
}

