/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.context;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import javax.crypto.SealedObject;
import org.switchyard.Exchange;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.security.context.DefaultSecurityContext;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.crypto.PrivateCrypto;
import org.switchyard.security.service.SecureServiceDomain;
import org.switchyard.security.service.ServiceDomainSecurity;
import org.switchyard.security.system.SystemSecurity;

public final class SecurityContextManager {
    private static final String FORMAT = SecurityContextManager.class.getSimpleName() + "@%s[systemSecurity=%s]";
    private static final String EXCHANGE_PROPERTY = SecurityContext.class.getName();
    private static final ThreadLocal<SecurityContext> THREAD_LOCAL = new InheritableThreadLocal<SecurityContext>();
    private SystemSecurity _systemSecurity = null;

    public SecurityContextManager(ServiceDomain serviceDomain) {
        ServiceDomainSecurity serviceDomainSecurity;
        if (serviceDomain instanceof SecureServiceDomain && (serviceDomainSecurity = ((SecureServiceDomain)serviceDomain).getServiceDomainSecurity()) != null) {
            this._systemSecurity = serviceDomainSecurity.getSystemSecurity();
        }
        if (this._systemSecurity == null) {
            this._systemSecurity = SystemSecurity.DEFAULT;
        }
    }

    public SecurityContext getContext(Exchange exchange) {
        return this.getContext(exchange, true);
    }

    public SecurityContext createContext() {
        DefaultSecurityContext securityContext = null;
        Long timeoutMillis = this._systemSecurity.getSecurityContextTimeoutMillis();
        UUID systemUUID = this._systemSecurity.getUUID();
        securityContext = new DefaultSecurityContext(systemUUID, timeoutMillis);
        return securityContext;
    }

    public SecurityContext getContext(Exchange exchange, boolean create) {
        SecurityContext securityContext = null;
        Property property = exchange.getContext().getProperty(EXCHANGE_PROPERTY, Scope.EXCHANGE);
        if (property != null) {
            Object object = property.getValue();
            if (object instanceof SecurityContext) {
                securityContext = (SecurityContext)object;
            } else if (object instanceof SealedObject) {
                PrivateCrypto privateCrypto = this._systemSecurity.getPrivateCrypto();
                if (privateCrypto == null) {
                    throw new IllegalStateException("privateCrypto == null");
                }
                securityContext = (SecurityContext)privateCrypto.unseal((SealedObject)object);
            } else if (object != null) {
                throw new IllegalArgumentException(object.getClass().getName() + " != " + EXCHANGE_PROPERTY);
            }
        }
        UUID systemUUID = this._systemSecurity.getUUID();
        if ((securityContext == null || !securityContext.isValid(systemUUID)) && create) {
            Long timeoutMillis = this._systemSecurity.getSecurityContextTimeoutMillis();
            securityContext = new DefaultSecurityContext(systemUUID, timeoutMillis);
        }
        return securityContext;
    }

    public void setContext(Exchange exchange, SecurityContext securityContext) {
        Property property;
        PrivateCrypto privateCrypto;
        THREAD_LOCAL.set(securityContext);
        Serializable object = securityContext;
        if (object != null && (privateCrypto = this._systemSecurity.getPrivateCrypto()) != null) {
            object = privateCrypto.seal(object);
        }
        if ((property = exchange.getContext().setProperty(EXCHANGE_PROPERTY, (Object)object, Scope.EXCHANGE)) != null) {
            property.addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
    }

    public void addCredentials(Exchange exchange, Set<Credential> credentials) {
        if (credentials != null && credentials.size() > 0) {
            SecurityContext securityContext = this.getContext(exchange);
            securityContext.getCredentials().addAll(credentials);
            this.setContext(exchange, securityContext);
        }
    }

    public void propagateContext(Exchange toExchange) {
        SecurityContext securityContext = THREAD_LOCAL.get();
        this.setContext(toExchange, securityContext);
    }

    public void propagateContext(Exchange fromExchange, Exchange toExchange) {
        this.setContext(toExchange, this.getContext(fromExchange, false));
    }

    public String toString() {
        return String.format(FORMAT, System.identityHashCode(this), this._systemSecurity);
    }
}

