/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.component.http.ContentType;
import org.switchyard.component.http.HttpLogger;
import org.switchyard.component.http.InboundHandler;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpRequestInfo;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.security.SecurityServices;
import org.switchyard.security.credential.extractor.ServletRequestCredentialExtractor;

public class HttpGatewayServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static ServletRequestCredentialExtractor srce = SecurityServices.getServletRequestCredentialExtractor();
    private static final Logger LOGGER = Logger.getLogger(HttpGatewayServlet.class);
    private static final Map<String, String> LOCALNAMEMAP = new ConcurrentHashMap<String, String>();
    private transient InboundHandler _handler;
    private transient ClassLoader _classLoader;

    private static final String getLocalName(HttpServletRequest request) {
        String localAddr = request.getLocalAddr();
        String localName = LOCALNAMEMAP.get(localAddr);
        if (localName == null) {
            localName = request.getLocalName();
            LOCALNAMEMAP.put(localAddr, localName);
        }
        return localName;
    }

    public void setHandler(InboundHandler handler) {
        this._handler = handler;
    }

    public void setClassLoader(ClassLoader loader) {
        this._classLoader = loader;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpRequestBindingData httpRequest = new HttpRequestBindingData();
        try {
            httpRequest.setContentType(new ContentType(request.getContentType()));
            httpRequest.setBodyFromStream((InputStream)request.getInputStream());
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    httpRequest.addHeader(name, value);
                }
            }
            httpRequest.setRequestInfo(this.getRequestInfo(request));
        }
        catch (IOException e) {
            response.setStatus(500);
            HttpLogger.ROOT_LOGGER.unexpectedExceptionWhileReadingRequest(e);
        }
        ClassLoader origCl = null;
        try {
            HttpResponseBindingData httpResponse;
            if (this._classLoader != null) {
                origCl = Classes.setTCCL((ClassLoader)this._classLoader);
            }
            if ((httpResponse = this._handler.invoke(httpRequest)) != null) {
                for (Map.Entry<String, List<String>> entry : httpResponse.getHeaders().entrySet()) {
                    String name = entry.getKey();
                    List<String> values = entry.getValue();
                    for (String value : values) {
                        response.addHeader(name, value);
                    }
                }
                if (httpResponse.getBodyBytes() != null) {
                    response.setStatus(httpResponse.getStatus().intValue());
                    httpResponse.writeBodyToStream((OutputStream)response.getOutputStream());
                } else if (httpResponse.getStatus() != null) {
                    response.setStatus(httpResponse.getStatus().intValue());
                } else {
                    response.setStatus(202);
                    response.setContentLength(0);
                }
            } else {
                response.setStatus(500);
            }
            if (origCl == null) return;
        }
        catch (Exception e) {
            try {
                response.setStatus(500);
                HttpLogger.ROOT_LOGGER.unexpectedExceptionWhileWritingResponse(e);
                if (origCl == null) return;
            }
            catch (Throwable throwable) {
                if (origCl == null) throw throwable;
                Classes.setTCCL(origCl);
                throw throwable;
            }
            Classes.setTCCL((ClassLoader)origCl);
            return;
        }
        Classes.setTCCL((ClassLoader)origCl);
        return;
    }

    public HttpRequestInfo getRequestInfo(HttpServletRequest request) {
        Map paramMap;
        HttpRequestInfo requestInfo = new HttpRequestInfo();
        requestInfo.setAuthType(request.getAuthType());
        requestInfo.setCharacterEncoding(request.getCharacterEncoding());
        requestInfo.setContentType(request.getContentType());
        requestInfo.setContextPath(request.getContextPath());
        requestInfo.setLocalAddr(request.getLocalAddr());
        requestInfo.setLocalName(HttpGatewayServlet.getLocalName(request));
        requestInfo.setMethod(request.getMethod());
        requestInfo.setProtocol(request.getProtocol());
        requestInfo.setQueryString(request.getQueryString());
        requestInfo.setRemoteAddr(request.getRemoteAddr());
        requestInfo.setRemoteHost(request.getRemoteHost());
        requestInfo.setRemoteUser(request.getRemoteUser());
        requestInfo.setContentLength(request.getContentLength());
        requestInfo.setRequestSessionId(request.getRequestedSessionId());
        requestInfo.setRequestURI(request.getRequestURI());
        requestInfo.setScheme(request.getScheme());
        requestInfo.setServerName(request.getServerName());
        requestInfo.setRequestPath(request.getServletPath());
        String pathInfo = request.getPathInfo();
        requestInfo.setPathInfo(pathInfo);
        if (pathInfo != null) {
            List<String> pathInfoTokens = requestInfo.getPathInfoTokens();
            pathInfoTokens.addAll(Arrays.asList(request.getPathInfo().split("/")));
            Iterator<String> tokensIterator = pathInfoTokens.iterator();
            while (tokensIterator.hasNext()) {
                if (tokensIterator.next().trim().length() != 0) continue;
                tokensIterator.remove();
            }
        }
        if ((paramMap = request.getParameterMap()) != null) {
            requestInfo.getQueryParams().putAll(paramMap);
        }
        requestInfo.getCredentials().addAll(srce.extract((Object)request));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)requestInfo);
        }
        return requestInfo;
    }
}

