/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigInteger;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public abstract class IntegerValue
extends NumericValue {
    public static final Int64Value MINUS_ONE = new Int64Value(-1L);
    public static final Int64Value ZERO = new Int64Value(0L);
    public static final Int64Value PLUS_ONE = new Int64Value(1L);
    public static final Int64Value[] SMALL_INTEGERS = new Int64Value[]{ZERO, PLUS_ONE, new Int64Value(2L), new Int64Value(3L), new Int64Value(4L), new Int64Value(5L), new Int64Value(6L), new Int64Value(7L), new Int64Value(8L), new Int64Value(9L), new Int64Value(10L), new Int64Value(11L), new Int64Value(12L), new Int64Value(13L), new Int64Value(14L), new Int64Value(15L), new Int64Value(16L), new Int64Value(17L), new Int64Value(18L), new Int64Value(19L), new Int64Value(20L)};
    public static final Int64Value MAX_LONG = new Int64Value(Long.MAX_VALUE);
    public static final Int64Value MIN_LONG = new Int64Value(Long.MIN_VALUE);
    private static long NO_LIMIT = -9999L;
    private static long MAX_UNSIGNED_LONG = -9998L;
    private static long[] ranges = new long[]{532L, NO_LIMIT, NO_LIMIT, 535L, Long.MIN_VALUE, Long.MAX_VALUE, 536L, Integer.MIN_VALUE, Integer.MAX_VALUE, 537L, -32768L, 32767L, 538L, -128L, 127L, 539L, 0L, NO_LIMIT, 540L, 1L, NO_LIMIT, 533L, NO_LIMIT, 0L, 534L, NO_LIMIT, -1L, 541L, 0L, MAX_UNSIGNED_LONG, 542L, 0L, 0xFFFFFFFFL, 543L, 0L, 65535L, 544L, 0L, 255L};

    public static IntegerValue makeIntegerValue(BigInteger value) {
        if (value.compareTo(BigIntegerValue.MAX_LONG) > 0 || value.compareTo(BigIntegerValue.MIN_LONG) < 0) {
            return new BigIntegerValue(value);
        }
        return Int64Value.makeIntegerValue(value.longValue());
    }

    public abstract ValidationFailure convertToSubType(BuiltInAtomicType var1, boolean var2);

    public abstract ValidationFailure validateAgainstSubType(BuiltInAtomicType var1);

    public static boolean checkRange(long value, BuiltInAtomicType type) {
        int fp = type.getFingerprint();
        for (int i = 0; i < ranges.length; i += 3) {
            if (ranges[i] != (long)fp) continue;
            long min = ranges[i + 1];
            if (min != NO_LIMIT && value < min) {
                return false;
            }
            long max = ranges[i + 2];
            return max == NO_LIMIT || max == MAX_UNSIGNED_LONG || value <= max;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + type.getDescription());
    }

    public static boolean checkBigRange(BigInteger big, BuiltInAtomicType type) {
        for (int i = 0; i < ranges.length; i += 3) {
            if (ranges[i] != (long)type.getFingerprint()) continue;
            long min = ranges[i + 1];
            if (min != NO_LIMIT && BigInteger.valueOf(min).compareTo(big) > 0) {
                return false;
            }
            long max = ranges[i + 2];
            if (max == NO_LIMIT) {
                return true;
            }
            if (max == MAX_UNSIGNED_LONG) {
                return BigIntegerValue.MAX_UNSIGNED_LONG.compareTo(big) >= 0;
            }
            return BigInteger.valueOf(max).compareTo(big) >= 0;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + type.getDescription());
    }

    public static ConversionResult stringToInteger(CharSequence s) {
        int start;
        int len = s.length();
        int last = len - 1;
        for (start = 0; start < len && s.charAt(start) <= ' '; ++start) {
        }
        while (last > start && s.charAt(last) <= ' ') {
            --last;
        }
        if (start > last) {
            return IntegerValue.numericError("Cannot convert zero-length string to an integer");
        }
        if (last - start < 16) {
            boolean negative = false;
            long value = 0L;
            int i = start;
            if (s.charAt(i) == '+') {
                ++i;
            } else if (s.charAt(i) == '-') {
                negative = true;
                ++i;
            }
            if (i > last) {
                return IntegerValue.numericError("Cannot convert string " + Err.wrap(s, 4) + " to integer: no digits after the sign");
            }
            while (i <= last) {
                char d;
                if ((d = s.charAt(i++)) >= '0' && d <= '9') {
                    value = 10L * value + (long)(d - 48);
                    continue;
                }
                return IntegerValue.numericError("Cannot convert string " + Err.wrap(s, 4) + " to an integer");
            }
            return Int64Value.makeIntegerValue(negative ? -value : value);
        }
        try {
            CharSequence t = Whitespace.trimWhitespace(s);
            if (t.charAt(0) == '+') {
                t = t.subSequence(1, t.length());
            }
            if (t.length() < 16) {
                return new Int64Value(Long.parseLong(((Object)t).toString()));
            }
            return new BigIntegerValue(new BigInteger(((Object)t).toString()));
        }
        catch (NumberFormatException err) {
            return IntegerValue.numericError("Cannot convert string " + Err.wrap(s, 4) + " to an integer");
        }
    }

    private static ValidationFailure numericError(String message) {
        ValidationFailure err = new ValidationFailure(message);
        err.setErrorCode("FORG0001");
        return err;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.INTEGER;
    }

    public boolean isWholeNumber() {
        return true;
    }

    public abstract IntegerValue plus(IntegerValue var1);

    public abstract IntegerValue minus(IntegerValue var1);

    public abstract IntegerValue times(IntegerValue var1);

    public abstract NumericValue div(IntegerValue var1) throws XPathException;

    public abstract IntegerValue mod(IntegerValue var1) throws XPathException;

    public abstract IntegerValue idiv(IntegerValue var1) throws XPathException;

    public abstract BigInteger asBigInteger();

    protected static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    public boolean isIdentical(Value v) {
        return v instanceof IntegerValue && this.equals(v);
    }
}

