/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.utils.ObjectPrinter;

@Deprecated
public class OutstandingRequestManager
implements Serializable {
    private static final long serialVersionUID = -5556374398943757951L;
    private static final Log __log = LogFactory.getLog(OutstandingRequestManager.class);
    public final Map<RequestIdTuple, Entry> _byRid = new HashMap<RequestIdTuple, Entry>();
    public final Map<String, Entry> _byChannel = new HashMap<String, Entry>();

    int findConflict(Selector[] selectors) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"findConflict", (Object[])new Object[]{"selectors", selectors}));
        }
        HashSet<RequestIdTuple> workingSet = new HashSet<RequestIdTuple>(this._byRid.keySet());
        for (int i = 0; i < selectors.length; ++i) {
            if (selectors[i].oneWay) continue;
            RequestIdTuple rid = new RequestIdTuple(selectors[i].plinkInstance, selectors[i].opName, selectors[i].messageExchangeId);
            if (workingSet.contains(rid)) {
                return i;
            }
            workingSet.add(rid);
        }
        return -1;
    }

    void register(String pickResponseChannel, Selector[] selectors) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"register", (Object[])new Object[]{"pickResponseChannel", pickResponseChannel, "selectors", selectors}));
        }
        if (this._byChannel.containsKey(pickResponseChannel)) {
            String errmsg = "INTERNAL ERROR: Duplicate ENTRY for RESPONSE CHANNEL " + pickResponseChannel;
            __log.fatal((Object)errmsg);
            throw new IllegalArgumentException(errmsg);
        }
        Entry entry = new Entry(pickResponseChannel, selectors);
        for (int i = 0; i < selectors.length; ++i) {
            if (selectors[i].oneWay) continue;
            RequestIdTuple rid = new RequestIdTuple(selectors[i].plinkInstance, selectors[i].opName, selectors[i].messageExchangeId);
            if (this._byRid.containsKey(rid)) {
                String errmsg = "INTERNAL ERROR: Duplicate ENTRY for RID " + rid;
                __log.fatal((Object)errmsg);
                throw new IllegalStateException(errmsg);
            }
            this._byRid.put(rid, entry);
        }
        this._byChannel.put(pickResponseChannel, entry);
    }

    void cancel(String pickResponseChannel) {
        Entry entry;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"cancel", (Object[])new Object[]{"pickResponseChannel", pickResponseChannel}));
        }
        if ((entry = this._byChannel.remove(pickResponseChannel)) != null) {
            while (this._byRid.values().remove(entry)) {
            }
        }
    }

    void associate(String pickResponseChannel, String mexRef) {
        Entry entry;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"associate", (Object[])new Object[]{"pickResponseChannel", pickResponseChannel, "mexRef", mexRef}));
        }
        if ((entry = this._byChannel.get(pickResponseChannel)) == null) {
            String errmsg = "INTERNAL ERROR: No ENTRY for RESPONSE CHANNEL " + pickResponseChannel;
            __log.fatal((Object)errmsg);
            throw new IllegalArgumentException(errmsg);
        }
        entry.mexRef = mexRef;
    }

    public String release(PartnerLinkInstance plinkInstnace, String opName, String mexId) {
        RequestIdTuple rid;
        Entry entry;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"release", (Object[])new Object[]{"plinkInstance", plinkInstnace, "opName", opName, "mexId", mexId}));
        }
        if ((entry = this._byRid.get(rid = new RequestIdTuple(plinkInstnace, opName, mexId))) == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("==release: RID " + rid + " not found in " + this._byRid));
            }
            return null;
        }
        while (this._byChannel.values().remove(entry)) {
        }
        while (this._byRid.values().remove(entry)) {
        }
        return entry.mexRef;
    }

    public String[] releaseAll() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"releaseAll", null));
        }
        ArrayList<String> mexRefs = new ArrayList<String>();
        for (Entry entry : this._byChannel.values()) {
            if (entry.mexRef == null) continue;
            mexRefs.add(entry.mexRef);
        }
        this._byChannel.values().clear();
        this._byRid.values().clear();
        return mexRefs.toArray(new String[mexRefs.size()]);
    }

    public String toString() {
        return ObjectPrinter.toString((Object)this, (Object[])new Object[]{"byRid", this._byRid, "byChannel", this._byChannel});
    }

    public Map<RequestIdTuple, Entry> getRids() {
        return this._byRid;
    }

    public class Entry
    implements Serializable {
        private static final long serialVersionUID = -583743124656582887L;
        public final String pickResponseChannel;
        public Object[] selectors;
        public String mexRef;

        private Entry(String pickResponseChannel, Selector[] selectors) {
            this.pickResponseChannel = pickResponseChannel;
            this.selectors = selectors;
        }

        public String toString() {
            return ObjectPrinter.toString((Object)this, (Object[])new Object[]{"pickResponseChannel", this.pickResponseChannel, "selectors", this.selectors, "mexRef", this.mexRef});
        }
    }

    public class RequestIdTuple
    implements Serializable {
        private static final long serialVersionUID = -1059389611839777482L;
        public PartnerLinkInstance partnerLink;
        public String opName;
        public String mexId;

        private RequestIdTuple(PartnerLinkInstance partnerLink, String opName, String mexId) {
            this.partnerLink = partnerLink;
            this.opName = opName;
            this.mexId = mexId == null ? "" : mexId;
        }

        public int hashCode() {
            return this.partnerLink.hashCode() ^ this.opName.hashCode() ^ this.mexId.hashCode();
        }

        public boolean equals(Object obj) {
            RequestIdTuple other = (RequestIdTuple)obj;
            return other.partnerLink.equals(this.partnerLink) && other.opName.equals(this.opName) && other.mexId.equals(this.mexId);
        }

        public String toString() {
            return ObjectPrinter.toString((Object)this, (Object[])new Object[]{"partnerLink", this.partnerLink, "opName", this.opName, "mexId", this.mexId});
        }
    }
}

