/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca;

import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.mwlabs.wst11.at.context.TxContextImple;
import java.io.IOException;
import javax.transaction.Transaction;
import javax.xml.namespace.QName;
import org.jboss.jbossts.txbridge.outbound.OutboundBridge;
import org.jboss.jbossts.txbridge.outbound.OutboundBridgeManager;
import org.jboss.logging.Logger;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.sca.SCAMessages;
import org.switchyard.component.sca.TransactionContextSerializer;
import org.switchyard.config.model.composite.SCABindingModel;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.RemoteRegistry;
import org.switchyard.remote.cluster.ClusteredInvoker;
import org.switchyard.remote.cluster.LoadBalanceStrategy;
import org.switchyard.remote.cluster.RandomStrategy;
import org.switchyard.remote.cluster.RoundRobinStrategy;
import org.switchyard.remote.http.HttpInvokerLabel;

public class SCAInvoker
extends BaseServiceHandler {
    public static final String CONTEXT_PROPERTY_PREFIX = "org.switchyard.component.sca.";
    public static final String KEY_TARGET_SERVICE = "targetService";
    public static final String KEY_TARGET_NAMESPACE = "targetNamespace";
    private static Logger _log = Logger.getLogger(SCAInvoker.class);
    private final String _bindingName;
    private final String _referenceName;
    private final String _targetService;
    private final String _targetNamespace;
    private final boolean _clustered;
    private ClusteredInvoker _invoker;
    private boolean _preferLocal;
    private boolean _disableRemoteTransaction = false;
    private TransactionContextSerializer _txSerializer = new TransactionContextSerializer();

    public SCAInvoker(SCABindingModel config) {
        this._bindingName = config.getName();
        this._referenceName = config.getReference().getName();
        this._targetService = config.getTarget();
        this._targetNamespace = config.getTargetNamespace();
        this._clustered = config.isClustered();
        this._preferLocal = config.isPreferLocal();
    }

    public SCAInvoker(SCABindingModel config, RemoteRegistry registry) {
        this(config);
        if (config.isLoadBalanced()) {
            LoadBalanceStrategy loadBalancer = this.createLoadBalancer(config.getLoadBalance());
            this._invoker = new ClusteredInvoker(registry, loadBalancer);
        } else {
            this._invoker = new ClusteredInvoker(registry);
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._bindingName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        if (this.getState() != Lifecycle.State.STARTED) {
            throw SCAMessages.MESSAGES.referenceBindingNotStarted(this._referenceName, this._bindingName);
        }
        try {
            QName serviceName = this.getTargetServiceName(exchange);
            ServiceReference ref = exchange.getProvider().getDomain().getServiceReference(serviceName);
            if (this._clustered) {
                if (this._preferLocal && ref != null) {
                    this.invokeLocal(exchange, ref);
                } else {
                    this.invokeRemote(exchange, serviceName);
                }
            } else {
                if (ref == null) {
                    throw SCAMessages.MESSAGES.serviceReferenceNotFoundInDomain(serviceName.toString(), exchange.getProvider().getDomain().getName().toString());
                }
                this.invokeLocal(exchange, ref);
            }
        }
        catch (SwitchYardException syEx) {
            throw new HandlerException(syEx.getMessage());
        }
    }

    public SCAInvoker setDisableRemoteTransaction(boolean disable) {
        this._disableRemoteTransaction = disable;
        return this;
    }

    void setInvoker(ClusteredInvoker invoker) {
        this._invoker = invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeLocal(Exchange exchange, ServiceReference targetRef) throws HandlerException {
        Exchange ex;
        SynchronousInOutHandler replyHandler;
        block4: {
            replyHandler = new SynchronousInOutHandler();
            ex = targetRef.createExchange(exchange.getContract().getProviderOperation().getName(), (ExchangeHandler)replyHandler);
            Message invokeMsg = exchange.getMessage().copy();
            exchange.getContext().mergeInto(invokeMsg.getContext());
            ClassLoader origCL = null;
            try {
                ClassLoader targetCL = (ClassLoader)targetRef.getDomain().getProperty("org.switchyard.deployment.DeploymentClassLoader");
                origCL = Classes.setTCCL((ClassLoader)targetCL);
                ex.send(invokeMsg);
                if (origCL == null) break block4;
            }
            catch (Throwable throwable) {
                if (origCL == null) throw throwable;
                Classes.setTCCL(origCL);
                throw throwable;
            }
            Classes.setTCCL((ClassLoader)origCL);
        }
        if (!ExchangePattern.IN_OUT.equals((Object)ex.getPattern())) {
            if (!ExchangeState.FAULT.equals((Object)ex.getState())) return;
            throw this.createHandlerException(ex.getMessage());
        }
        replyHandler.waitForOut();
        if (ex.getMessage() == null) return;
        Message replyMsg = ex.getMessage().copy();
        ex.getContext().mergeInto(replyMsg.getContext());
        if (ExchangeState.FAULT.equals((Object)ex.getState())) {
            exchange.sendFault(replyMsg);
            return;
        }
        exchange.send(replyMsg);
    }

    private void invokeRemote(Exchange exchange, QName serviceName) throws HandlerException {
        RemoteMessage request = new RemoteMessage().setDomain(exchange.getProvider().getDomain().getName()).setService(serviceName).setOperation(exchange.getContract().getConsumerOperation().getName()).setContent(exchange.getMessage().getContent());
        exchange.getContext().mergeInto(request.getContext());
        boolean transactionPropagated = this.bridgeOutgoingTransaction(request);
        try {
            RemoteMessage reply = this._invoker.invoke(request);
            if (transactionPropagated) {
                this.bridgeIncomingTransaction();
            }
            if (reply == null) {
                return;
            }
            if (ExchangePattern.IN_OUT.equals((Object)exchange.getPattern())) {
                Message msg = exchange.createMessage();
                msg.setContent(reply.getContent());
                Context replyCtx = reply.getContext();
                if (replyCtx != null) {
                    replyCtx.mergeInto(exchange.getContext());
                }
                if (reply.isFault()) {
                    exchange.sendFault(msg);
                } else {
                    exchange.send(msg);
                }
            } else if (reply.isFault()) {
                throw this.createHandlerException(reply.getContent());
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            exchange.sendFault(exchange.createMessage().setContent((Object)ioEx));
        }
    }

    private QName getTargetServiceName(Exchange exchange) {
        String targetNS;
        QName service = exchange.getProvider().getName();
        String targetName = (String)exchange.getContext().getPropertyValue("org.switchyard.component.sca.targetService");
        if (targetName == null) {
            String string = targetName = this._targetService != null ? this._targetService : service.getLocalPart();
        }
        if ((targetNS = (String)exchange.getContext().getPropertyValue("org.switchyard.component.sca.targetNamespace")) == null) {
            targetNS = this._targetNamespace != null ? this._targetNamespace : service.getNamespaceURI();
        }
        return new QName(targetNS, targetName);
    }

    private boolean bridgeOutgoingTransaction(RemoteMessage request) throws HandlerException {
        Transaction currentTransaction;
        block10: {
            if (this._disableRemoteTransaction) {
                return false;
            }
            currentTransaction = null;
            try {
                currentTransaction = com.arjuna.ats.jta.TransactionManager.transactionManager().getTransaction();
            }
            catch (Throwable t) {
                if (!_log.isDebugEnabled()) break block10;
                _log.debug((Object)t);
            }
        }
        if (currentTransaction == null) {
            return false;
        }
        try {
            TxContextImple txContext;
            OutboundBridge txOutboundBridge = OutboundBridgeManager.getOutboundBridge();
            if (txOutboundBridge == null) {
                return false;
            }
            txOutboundBridge.start();
            TransactionManager wsatManager = TransactionManagerFactory.transactionManager();
            CoordinationContextType coordinationContext = null;
            if (wsatManager != null && (txContext = (TxContextImple)wsatManager.currentTransaction()) != null) {
                coordinationContext = txContext.context().getCoordinationContext();
            }
            if (coordinationContext != null) {
                String txContextString = this._txSerializer.serialise(coordinationContext);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Embedding transaction context into request header: " + txContextString));
                }
                request.getContext().setProperty("switchyard-transaction-context", (Object)txContextString).addLabels(new String[]{BehaviorLabel.TRANSIENT.label(), HttpInvokerLabel.HEADER.label()});
            }
            return true;
        }
        catch (Throwable th) {
            throw this.createHandlerException(th);
        }
    }

    private void bridgeIncomingTransaction() throws HandlerException {
        OutboundBridge txOutboundBridge = OutboundBridgeManager.getOutboundBridge();
        if (txOutboundBridge != null) {
            try {
                txOutboundBridge.stop();
            }
            catch (Exception e) {
                throw this.createHandlerException(e);
            }
        }
    }

    private HandlerException createHandlerException(Message message) {
        return this.createHandlerException(message == null ? null : message.getContent());
    }

    private HandlerException createHandlerException(Object content) {
        HandlerException ex = content == null ? SCAMessages.MESSAGES.runtimeFaultOccurredWithoutExceptionDetails() : (content instanceof HandlerException ? (HandlerException)content : (content instanceof Throwable ? new HandlerException((Throwable)content) : new HandlerException(content.toString())));
        return ex;
    }

    LoadBalanceStrategy createLoadBalancer(String strategy) {
        if (RoundRobinStrategy.class.getSimpleName().equals(strategy)) {
            return new RoundRobinStrategy();
        }
        if (RandomStrategy.class.getSimpleName().equals(strategy)) {
            return new RandomStrategy();
        }
        try {
            Class<?> strategyClass = Class.forName(strategy);
            if (!LoadBalanceStrategy.class.isAssignableFrom(strategyClass)) {
                throw SCAMessages.MESSAGES.loadBalanceClassDoesNotImplementLoadBalanceStrategy(strategy);
            }
            return (LoadBalanceStrategy)strategyClass.newInstance();
        }
        catch (Exception ex) {
            throw SCAMessages.MESSAGES.unableToInstantiateStrategyClass(strategy, ex);
        }
    }
}

