/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.ode.bpel.o.OAgent;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OFailureHandling;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OProcess;

public abstract class OActivity
extends OAgent {
    static final long serialVersionUID = -1L;
    public OExpression joinCondition;
    public boolean suppressJoinFailure;
    public final Set<OLink> sourceLinks = new HashSet<OLink>();
    public final Set<OLink> targetLinks = new HashSet<OLink>();
    public String name;
    public OFailureHandling failureHandling;
    private OActivity parent;

    public String getType() {
        return this.getClass().getSimpleName();
    }

    public OActivity(OProcess owner, OActivity parent) {
        super(owner);
        this.parent = parent;
    }

    public OActivity getParent() {
        return this.parent;
    }

    public OFailureHandling getFailureHandling() {
        OFailureHandling handling = this.failureHandling;
        if (handling == null) {
            OActivity parent = this.parent;
            while (parent != null && handling == null) {
                handling = parent.failureHandling;
                parent = parent.parent;
            }
        }
        return handling;
    }

    public void setFailureHandling(OFailureHandling failureHandling) {
        this.failureHandling = failureHandling;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        if (this.name != null) {
            buf.append('-');
            buf.append(this.name);
        }
        return buf.toString();
    }

    @Override
    public String digest() {
        StringBuffer buf = new StringBuffer(this.getClass().getSimpleName());
        buf.append('#');
        buf.append(this.getId());
        buf.append("{");
        ArrayList l = new ArrayList();
        l.addAll(this.nested);
        Collections.sort(l, new Comparator<OAgent>(){

            private String key(OAgent o) {
                return o.getClass().getSimpleName() + "#" + o.getId();
            }

            @Override
            public int compare(OAgent o1, OAgent o2) {
                return this.key(o1).compareTo(this.key(o2));
            }
        });
        for (OAgent child : l) {
            buf.append(child.digest());
            buf.append(";");
        }
        buf.append("}");
        return buf.toString();
    }
}

